/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.container.html;

import java.io.IOException;
import java.util.List;
import org.rendersnake.HtmlAttributesFactory;
import org.rendersnake.HtmlCanvas;
import org.rendersnake.internal.CharactersWriteable;
import org.streampipes.container.html.model.DataSourceDescriptionHtml;
import org.streampipes.container.html.model.Description;

public class HTMLGenerator {
    private List<Description> descriptions;

    public HTMLGenerator(List<Description> descriptions) {
        this.descriptions = descriptions;
    }

    public String buildHtml() {
        HtmlCanvas html = new HtmlCanvas();
        try {
            html.head().meta((CharactersWriteable)HtmlAttributesFactory.name((String)"viewport").content("width=device-width, initial-scale=1")).macros().javascript("https://maxcdn.bootstrapcdn.com/bootstrap/3.3.1/js/bootstrap.min.js").macros().stylesheet("https://maxcdn.bootstrapcdn.com/bootstrap/3.3.1/css/bootstrap.min.css").macros().javascript("https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js").style().write("body {padding-top: 70px;}")._style()._head().body().nav((CharactersWriteable)HtmlAttributesFactory.class_((String)"navbar navbar-inverse navbar-fixed-top").style("background:#0A3F54")).div((CharactersWriteable)HtmlAttributesFactory.class_((String)"container")).div((CharactersWriteable)HtmlAttributesFactory.class_((String)"navbar-header")).a((CharactersWriteable)HtmlAttributesFactory.class_((String)"navbar-brand").style("color:white;")).content("StreamPipes Pipeline Element Container")._div()._div()._nav().div((CharactersWriteable)HtmlAttributesFactory.class_((String)"container"));
            html.h4().write("This is a developer-oriented view. Navigate to 'Install Pipeline Elements' in the StreamPipes UI to import the elements shown here.")._h4();
            for (Description description : this.descriptions) {
                html.h3();
                html.write(description.getName());
                html._h3();
                html.h4().write("URI: ").a((CharactersWriteable)HtmlAttributesFactory.href((String)description.getUri().toString())).content(description.getUri().toString())._h4();
                html.h4().write("Description: ").write(description.getDescription())._h4();
                if (!(description instanceof DataSourceDescriptionHtml)) continue;
                DataSourceDescriptionHtml semanticEventProducerDescription = (DataSourceDescriptionHtml)description;
                for (Description agentDesc : semanticEventProducerDescription.getStreams()) {
                    html.h5().b().write(agentDesc.getName())._b()._h5();
                    html.h5().write(agentDesc.getDescription())._h5();
                }
            }
            html._div();
            html._body();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return html.toHtml();
    }
}

