/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.container.api;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.rdf4j.model.Graph;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.streampipes.commons.Utils;
import org.streampipes.container.assets.AssetZipGenerator;
import org.streampipes.container.declarer.DataStreamDeclarer;
import org.streampipes.container.declarer.Declarer;
import org.streampipes.container.declarer.SemanticEventProducerDeclarer;
import org.streampipes.container.init.DeclarersSingleton;
import org.streampipes.container.locales.LabelGenerator;
import org.streampipes.container.transform.Transformer;
import org.streampipes.empire.core.empire.SupportsRdfId;
import org.streampipes.empire.core.empire.annotation.InvalidRdfException;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.graph.DataProcessorDescription;
import org.streampipes.model.graph.DataSinkDescription;
import org.streampipes.model.graph.DataSourceDescription;

public abstract class Element<D extends Declarer> {
    protected abstract Map<String, D> getElementDeclarers();

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public String getDescription(@PathParam(value="id") String elementId) {
        return this.getJsonLd(elementId);
    }

    @GET
    @Path(value="{id}/assets")
    @Produces(value={"application/zip"})
    public Response getAssets(@PathParam(value="id") String elementId) {
        List includedAssets = this.getDeclarerById(elementId).declareModel().getIncludedAssets();
        try {
            return Response.ok().entity((Object)new AssetZipGenerator(elementId, includedAssets).makeZip()).build();
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="{id}/assets/icon")
    @Produces(value={"image/png"})
    public Response getIconAsset(@PathParam(value="id") String elementId) throws IOException {
        URL iconUrl = Resources.getResource((String)this.makeIconPath(elementId));
        return Response.ok().entity((Object)Resources.toByteArray((URL)iconUrl)).build();
    }

    @GET
    @Path(value="{id}/assets/documentation")
    @Produces(value={"text/plain"})
    public String getDocumentationAsset(@PathParam(value="id") String elementId) throws IOException {
        URL documentationUrl = Resources.getResource((String)this.makeDocumentationPath(elementId));
        return Resources.toString((URL)documentationUrl, (Charset)Charsets.UTF_8);
    }

    protected String getJsonLd(String id) {
        NamedStreamPipesEntity elem = this.rewrite(this.getById(id));
        return this.toJsonLd(elem);
    }

    protected String getJsonLd(NamedStreamPipesEntity desc, String appendix) {
        return this.toJsonLd(this.rewrite(desc, appendix));
    }

    protected D getDeclarerById(String id) {
        return (D)((Declarer)this.getElementDeclarers().get(id));
    }

    protected NamedStreamPipesEntity getById(String id) {
        DataSourceDescription desc = null;
        Declarer declarer = (Declarer)this.getElementDeclarers().get(id);
        if (declarer instanceof SemanticEventProducerDeclarer) {
            DataSourceDescription secDesc = (DataSourceDescription)((SemanticEventProducerDeclarer)declarer).declareModel();
            List<DataStreamDeclarer> eventStreamDeclarers = ((SemanticEventProducerDeclarer)declarer).getEventStreams();
            for (DataStreamDeclarer esd : eventStreamDeclarers) {
                secDesc.addEventStream(esd.declareModel(secDesc));
            }
            desc = secDesc;
        } else {
            desc = (DataSourceDescription)declarer.declareModel();
        }
        return desc;
    }

    protected NamedStreamPipesEntity rewrite(NamedStreamPipesEntity desc) {
        return this.rewrite(desc, "");
    }

    protected NamedStreamPipesEntity rewrite(NamedStreamPipesEntity desc, String appendix) {
        if (desc != null) {
            String type = "";
            if (desc instanceof DataProcessorDescription) {
                type = "sepa/";
            } else if (desc instanceof DataSourceDescription) {
                type = "sep/";
            } else if (desc instanceof DataSinkDescription) {
                type = "sec/";
            } else if (desc instanceof SpDataStream) {
                type = "sep/" + appendix + "/";
            }
            String originalId = desc.getUri();
            String uri = DeclarersSingleton.getInstance().getBaseUri() + type + desc.getUri();
            desc.setUri(uri);
            desc.setRdfId((SupportsRdfId.RdfKey)new SupportsRdfId.URIKey(URI.create(uri)));
            if (desc.isIncludesLocales()) {
                try {
                    desc = new LabelGenerator(desc).generateLabels();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (desc instanceof DataSourceDescription) {
                for (SpDataStream stream : ((DataSourceDescription)desc).getSpDataStreams()) {
                    String baseUri = DeclarersSingleton.getInstance().getBaseUri() + type + originalId + "/" + stream.getUri();
                    stream.setUri(baseUri);
                    stream.setRdfId((SupportsRdfId.RdfKey)new SupportsRdfId.URIKey(URI.create(baseUri)));
                    if (!stream.isIncludesLocales()) continue;
                    try {
                        LabelGenerator lg = new LabelGenerator(desc);
                        stream.setName(lg.getElementTitle());
                        stream.setDescription(lg.getElementDescription());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return desc;
    }

    protected String toJsonLd(NamedStreamPipesEntity namedElement) {
        if (namedElement != null) {
            try {
                Graph rdfGraph = Transformer.toJsonLd(namedElement);
                return Utils.asString((Graph)rdfGraph);
            }
            catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException | RDFHandlerException | InvalidRdfException e) {
                e.printStackTrace();
            }
        }
        return "{}";
    }

    private String makeIconPath(String elementId) {
        return this.makePath(elementId, "icon.png");
    }

    private String makeDocumentationPath(String elementId) {
        return this.makePath(elementId, "documentation.md");
    }

    private String makePath(String elementId, String assetAppendix) {
        return elementId + "/" + assetAppendix;
    }
}

