/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.container.assets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class AssetZipGenerator {
    private List<String> includedAssets;
    private String appId;

    public AssetZipGenerator(String appId, List<String> includedAssets) {
        this.includedAssets = includedAssets;
        this.appId = appId;
    }

    public byte[] makeZip() throws IOException {
        return this.makeZipFromAssets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] makeZipFromAssets() throws IOException {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream out = new ZipOutputStream(outputStream);
        for (String asset : this.includedAssets) {
            ZipEntry ze = new ZipEntry(asset);
            out.putNextEntry(ze);
            try (InputStream in = null;){
                int len;
                ClassLoader classLoader = this.getClass().getClassLoader();
                in = classLoader.getResourceAsStream(this.makePath(asset));
                while ((len = in.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
            }
        }
        out.closeEntry();
        out.close();
        return outputStream.toByteArray();
    }

    private String makePath(String assetAppendix) {
        return this.appId + "/" + assetAppendix;
    }
}

