/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.container.html;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import org.streampipes.container.html.model.DataSourceDescriptionHtml;
import org.streampipes.container.html.model.Description;

public class JSONGenerator {
    private List<Description> description;

    public JSONGenerator(List<Description> description) {
        this.description = description;
    }

    public String buildJson() {
        JsonArray jsonArray = new JsonArray();
        this.description.forEach(d -> jsonArray.add((JsonElement)this.getJsonElement((Description)d)));
        return jsonArray.toString();
    }

    private JsonObject getJsonElement(Description d) {
        JsonObject obj = this.makeDescription(d);
        if (d instanceof DataSourceDescriptionHtml) {
            DataSourceDescriptionHtml producerDesc = (DataSourceDescriptionHtml)d;
            JsonArray array = new JsonArray();
            producerDesc.getStreams().forEach(s -> array.add((JsonElement)this.makeDescription((Description)s)));
            obj.add("streams", (JsonElement)array);
        }
        return obj;
    }

    private JsonObject makeDescription(Description d) {
        JsonObject obj = new JsonObject();
        obj.add("uri", (JsonElement)new JsonPrimitive(d.getUri().toString()));
        obj.add("name", (JsonElement)new JsonPrimitive(d.getName()));
        obj.add("description", (JsonElement)new JsonPrimitive(d.getDescription()));
        obj.add("type", (JsonElement)new JsonPrimitive(d.getType()));
        return obj;
    }
}

