/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.container.init;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.streampipes.container.declarer.DataStreamDeclarer;
import org.streampipes.container.declarer.Declarer;
import org.streampipes.container.declarer.PipelineTemplateDeclarer;
import org.streampipes.container.declarer.SemanticEventConsumerDeclarer;
import org.streampipes.container.declarer.SemanticEventProcessingAgentDeclarer;
import org.streampipes.container.declarer.SemanticEventProducerDeclarer;
import org.streampipes.dataformat.SpDataFormatFactory;
import org.streampipes.dataformat.SpDataFormatManager;
import org.streampipes.messaging.SpProtocolDefinitionFactory;
import org.streampipes.messaging.SpProtocolManager;
import org.streampipes.model.graph.DataProcessorDescription;
import org.streampipes.model.graph.DataSinkDescription;
import org.streampipes.model.graph.DataSourceDescription;

public class DeclarersSingleton {
    private static DeclarersSingleton instance;
    private static final String Http = "http://";
    private static final String Colon = ":";
    private static final String Slash = "/";
    private Map<String, SemanticEventProcessingAgentDeclarer> epaDeclarers = new HashMap<String, SemanticEventProcessingAgentDeclarer>();
    private Map<String, SemanticEventProducerDeclarer> producerDeclarers = new HashMap<String, SemanticEventProducerDeclarer>();
    private Map<String, SemanticEventConsumerDeclarer> consumerDeclarers = new HashMap<String, SemanticEventConsumerDeclarer>();
    private Map<String, PipelineTemplateDeclarer> pipelineTemplateDeclarers;
    private Map<String, DataStreamDeclarer> streamDeclarers = new HashMap<String, DataStreamDeclarer>();
    private int port;
    private String route = "/";
    private String hostName;

    private DeclarersSingleton() {
        this.pipelineTemplateDeclarers = new HashMap<String, PipelineTemplateDeclarer>();
    }

    public static DeclarersSingleton getInstance() {
        if (instance == null) {
            instance = new DeclarersSingleton();
        }
        return instance;
    }

    public void addDeclarers(List<Declarer> allDeclarers) {
        for (Declarer d : allDeclarers) {
            this.add(d);
        }
    }

    public DeclarersSingleton add(Declarer d) {
        if (d instanceof SemanticEventProcessingAgentDeclarer) {
            this.addEpaDeclarer((SemanticEventProcessingAgentDeclarer)d);
        } else if (d instanceof SemanticEventProducerDeclarer) {
            this.addProducerDeclarer((SemanticEventProducerDeclarer)d);
        } else if (d instanceof SemanticEventConsumerDeclarer) {
            this.addConsumerDeclarer((SemanticEventConsumerDeclarer)d);
        } else if (d instanceof PipelineTemplateDeclarer) {
            this.addPipelineTemplateDeclarer((PipelineTemplateDeclarer)d);
        }
        return DeclarersSingleton.getInstance();
    }

    public Map<String, Declarer> getDeclarers() {
        HashMap<String, Declarer> result = new HashMap<String, Declarer>();
        result.putAll(this.epaDeclarers);
        result.putAll(this.producerDeclarers);
        result.putAll(this.consumerDeclarers);
        result.putAll(this.pipelineTemplateDeclarers);
        return result;
    }

    public void registerProtocol(SpProtocolDefinitionFactory<?> protocol) {
        SpProtocolManager.INSTANCE.register(protocol);
    }

    public void registerDataFormat(SpDataFormatFactory dataFormatDefinition) {
        SpDataFormatManager.INSTANCE.register(dataFormatDefinition);
    }

    private void addEpaDeclarer(SemanticEventProcessingAgentDeclarer epaDeclarer) {
        this.epaDeclarers.put(((DataProcessorDescription)epaDeclarer.declareModel()).getAppId(), epaDeclarer);
    }

    private void addProducerDeclarer(SemanticEventProducerDeclarer sourceDeclarer) {
        this.checkAndStartExecutableStreams(sourceDeclarer);
        this.producerDeclarers.put(((DataSourceDescription)sourceDeclarer.declareModel()).getAppId(), sourceDeclarer);
        sourceDeclarer.getEventStreams().forEach(sd -> this.streamDeclarers.put(sd.declareModel((DataSourceDescription)sourceDeclarer.declareModel()).getAppId(), (DataStreamDeclarer)sd));
    }

    private void addConsumerDeclarer(SemanticEventConsumerDeclarer consumerDeclarer) {
        this.consumerDeclarers.put(((DataSinkDescription)consumerDeclarer.declareModel()).getAppId(), consumerDeclarer);
    }

    private void addPipelineTemplateDeclarer(PipelineTemplateDeclarer pipelineTemplateDeclarer) {
        this.pipelineTemplateDeclarers.put(pipelineTemplateDeclarer.declareModel().getAppId(), pipelineTemplateDeclarer);
    }

    public Map<String, SemanticEventProcessingAgentDeclarer> getEpaDeclarers() {
        return this.epaDeclarers;
    }

    public Map<String, SemanticEventProducerDeclarer> getProducerDeclarers() {
        return this.producerDeclarers;
    }

    public Map<String, SemanticEventConsumerDeclarer> getConsumerDeclarers() {
        return this.consumerDeclarers;
    }

    public Map<String, PipelineTemplateDeclarer> getPipelineTemplateDeclarers() {
        return this.pipelineTemplateDeclarers;
    }

    public Map<String, DataStreamDeclarer> getStreamDeclarers() {
        return this.streamDeclarers;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHostName(String host) {
        this.hostName = host;
    }

    public void setRoute(String route) {
        this.route = Slash + route + Slash;
    }

    public String getBaseUri() {
        return Http + this.hostName + Colon + this.port + this.route;
    }

    private void checkAndStartExecutableStreams(SemanticEventProducerDeclarer sourceDeclarer) {
        sourceDeclarer.getEventStreams().stream().filter(DataStreamDeclarer::isExecutable).forEach(es -> {
            es.declareModel((DataSourceDescription)sourceDeclarer.declareModel());
            es.executeStream();
        });
    }
}

