/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.container.locales;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.streampipes.container.util.LocalesUtil;
import org.streampipes.model.base.ConsumableStreamPipesEntity;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.graph.DataProcessorDescription;
import org.streampipes.model.output.AppendOutputStrategy;
import org.streampipes.model.output.FixedOutputStrategy;

public class LabelGenerator {
    private static final String Delimiter = ".";
    private static final String Title = "title";
    private static final String Description = "description";
    private NamedStreamPipesEntity desc;

    public LabelGenerator(NamedStreamPipesEntity desc) {
        this.desc = desc;
    }

    public NamedStreamPipesEntity generateLabels() throws IOException {
        if (this.existsLocalesFile()) {
            Properties props = this.makeProperties();
            this.desc.setName(this.getTitle(props, this.desc.getAppId()));
            this.desc.setDescription(this.getDescription(props, this.desc.getAppId()));
            if (this.isConsumable()) {
                ((ConsumableStreamPipesEntity)this.desc).getStaticProperties().forEach(sp -> {
                    sp.setLabel(this.getTitle(props, sp.getInternalName()));
                    sp.setDescription(this.getDescription(props, sp.getInternalName()));
                });
            }
            if (this.isDataProcessor()) {
                ((DataProcessorDescription)this.desc).getOutputStrategies().forEach(os -> {
                    if (os instanceof AppendOutputStrategy) {
                        ((AppendOutputStrategy)os).getEventProperties().forEach(ep -> {
                            ep.setLabel(this.getTitle(props, ep.getRuntimeId()));
                            ep.setDescription(this.getDescription(props, ep.getRuntimeId()));
                        });
                    } else if (os instanceof FixedOutputStrategy) {
                        ((FixedOutputStrategy)os).getEventProperties().forEach(ep -> {
                            ep.setLabel(this.getTitle(props, ep.getRuntimeId()));
                            ep.setDescription(this.getDescription(props, ep.getRuntimeId()));
                        });
                    }
                });
            }
        }
        return this.desc;
    }

    private Properties makeProperties() throws IOException {
        Properties props = new Properties();
        props.load(this.loadResource());
        return props;
    }

    public String getElementTitle() throws IOException {
        Properties props = this.makeProperties();
        return this.getTitle(props, this.desc.getAppId());
    }

    public String getElementDescription() throws IOException {
        Properties props = this.makeProperties();
        return this.getDescription(props, this.desc.getAppId());
    }

    private boolean existsLocalesFile() {
        return this.getClass().getClassLoader().getResourceAsStream(LocalesUtil.makePath(this.desc, (String)this.desc.getIncludedLocales().get(0))) != null;
    }

    private boolean isConsumable() {
        return this.desc instanceof ConsumableStreamPipesEntity;
    }

    private boolean isDataProcessor() {
        return this.desc instanceof DataProcessorDescription;
    }

    private InputStream loadResource() {
        if (this.desc.getIncludedLocales().size() > 0) {
            return this.getResourceFile((String)this.desc.getIncludedLocales().get(0));
        }
        throw new IllegalArgumentException("Could not find any language files");
    }

    private String getTitle(Properties props, String id) {
        return this.getValue(props, Title, id);
    }

    private String getDescription(Properties props, String id) {
        return this.getValue(props, Description, id);
    }

    private String getValue(Properties props, String type, String id) {
        return props.getProperty(id + Delimiter + type, "");
    }

    private InputStream getResourceFile(String filename) {
        return this.getClass().getClassLoader().getResourceAsStream(LocalesUtil.makePath(this.desc, filename));
    }
}

