/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.dataformat.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.streampipes.commons.exceptions.SpRuntimeException;
import org.streampipes.dataformat.SpDataFormatDefinition;

public class JsonDataFormatDefinition
implements SpDataFormatDefinition {
    private ObjectMapper objectMapper = new ObjectMapper();

    public Map<String, Object> toMap(byte[] event) throws SpRuntimeException {
        try {
            return (Map)this.objectMapper.readValue(new String(event), HashMap.class);
        }
        catch (IOException e) {
            throw new SpRuntimeException("Could not convert event to map data structure");
        }
    }

    public byte[] fromMap(Map<String, Object> event) throws SpRuntimeException {
        try {
            return this.objectMapper.writeValueAsBytes(event);
        }
        catch (JsonProcessingException e) {
            throw new SpRuntimeException("Could not convert map data structure to JSON string");
        }
    }
}

