/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.dataformat;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.streampipes.dataformat.SpDataFormatDefinition;
import org.streampipes.dataformat.SpDataFormatFactory;
import org.streampipes.model.grounding.TransportFormat;

public enum SpDataFormatManager {
    INSTANCE;

    private List<SpDataFormatFactory> availableDataFormats = new ArrayList<SpDataFormatFactory>();

    public void register(SpDataFormatFactory dataFormatDefinition) {
        this.availableDataFormats.add(dataFormatDefinition);
    }

    public List<SpDataFormatFactory> getAvailableDataFormats() {
        return this.availableDataFormats;
    }

    public Optional<SpDataFormatDefinition> findDefinition(TransportFormat transportFormat) {
        return this.availableDataFormats.stream().filter(adf -> transportFormat.getRdfType().stream().anyMatch(tf -> tf.toString().equals(adf.getTransportFormatRdfUri()))).map(SpDataFormatFactory::createInstance).findFirst();
    }
}

