/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.base;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class Durations {
    private static final Map<String, TimeUnit> UNITS = ImmutableMap.builder().put((Object)"ms", (Object)TimeUnit.MILLISECONDS).put((Object)"s", (Object)TimeUnit.SECONDS).put((Object)"m", (Object)TimeUnit.MINUTES).put((Object)"h", (Object)TimeUnit.HOURS).put((Object)"d", (Object)TimeUnit.DAYS).build();
    private static final EnumMap<TimeUnit, String> ABBR = Maps.newEnumMap((Map)HashBiMap.create(UNITS).inverse());

    private Durations() {
        throw new AssertionError();
    }

    public static String readable(long theMilliseconds) {
        return Durations.readable(theMilliseconds, TimeUnit.MILLISECONDS);
    }

    public static String readable(long theDuration, TimeUnit theUnit) {
        if (theDuration == 0L) {
            return "0ms";
        }
        Iterator<Map.Entry<TimeUnit, String>> aAbbrs = ABBR.entrySet().iterator();
        String aResult = null;
        boolean aFound = false;
        while (aAbbrs.hasNext()) {
            Map.Entry<TimeUnit, String> aEntry = aAbbrs.next();
            if (!aFound) {
                if (!aEntry.getKey().equals((Object)theUnit)) continue;
                aFound = true;
                aResult = theDuration + aEntry.getValue();
                continue;
            }
            TimeUnit aConvertUnit = aEntry.getKey();
            long aConverted = aConvertUnit.convert(theDuration, theUnit);
            if (theUnit.convert(aConverted, aConvertUnit) != theDuration) break;
            aResult = aConverted + aEntry.getValue();
        }
        return aResult;
    }

    public static long parse(String theDuration) throws IllegalArgumentException {
        return Durations.parse(theDuration, TimeUnit.MILLISECONDS);
    }

    public static long parse(String theDuration, TimeUnit theOutputUnit) {
        String[] aSplit = Durations.splitDuration(theDuration);
        long aVal = Durations.parseDuration(aSplit[0]);
        TimeUnit aUnit = Durations.parseTimeUnit(aSplit[1]);
        return theOutputUnit.convert(aVal, aUnit);
    }

    private static String[] splitDuration(String theStr) {
        String theTrimmedStr = theStr.trim();
        if (theTrimmedStr.length() < 2) {
            throw new IllegalArgumentException("Invalid duration: " + theStr);
        }
        int aSplit = theTrimmedStr.length() - 2;
        if (Character.isDigit(theStr.charAt(aSplit))) {
            ++aSplit;
        }
        return new String[]{theTrimmedStr.substring(0, aSplit), theTrimmedStr.substring(aSplit)};
    }

    private static TimeUnit parseTimeUnit(String theStr) {
        TimeUnit aUnit = UNITS.get(theStr.toLowerCase());
        if (aUnit == null) {
            throw new IllegalArgumentException("Invalid time unit: " + theStr);
        }
        return aUnit;
    }

    private static int parseDuration(String theStr) {
        int aVal = Integer.parseInt(theStr);
        if (aVal < 0) {
            throw new IllegalArgumentException("Invalid duration: " + theStr);
        }
        return aVal;
    }
}

