/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.base;

import java.util.Map;
import java.util.Properties;

public final class PropertiesBuilder {
    private Properties mProperties = new Properties();

    private PropertiesBuilder() {
    }

    public static PropertiesBuilder create() {
        return new PropertiesBuilder();
    }

    public static PropertiesBuilder create(Properties theProps) {
        PropertiesBuilder aBuilder = new PropertiesBuilder();
        aBuilder.mProperties.putAll((Map<?, ?>)theProps);
        return aBuilder;
    }

    public PropertiesBuilder set(String theKey, String theValue) {
        this.mProperties.setProperty(theKey, theValue);
        return this;
    }

    public PropertiesBuilder setTrue(String theKey) {
        return this.set(theKey, "true");
    }

    public PropertiesBuilder setFalse(String theKey) {
        return this.set(theKey, "false");
    }

    public PrefixedPropertiesBuilder withPrefix(String thePrefix) {
        return new PrefixedPropertiesBuilder(thePrefix);
    }

    public Properties build() {
        Properties aProps = new Properties();
        aProps.putAll((Map<?, ?>)this.mProperties);
        return aProps;
    }

    public final class PrefixedPropertiesBuilder {
        private final String mPrefix;

        public PrefixedPropertiesBuilder(String thePrefix) {
            this.mPrefix = thePrefix;
        }

        public PrefixedPropertiesBuilder set(String theKey, String theValue) {
            PropertiesBuilder.this.mProperties.setProperty(this.mPrefix + theKey, theValue);
            return this;
        }

        public PrefixedPropertiesBuilder setTrue(String theKey) {
            return this.set(theKey, "true");
        }

        public PrefixedPropertiesBuilder setFalse(String theKey) {
            return this.set(theKey, "false");
        }
    }
}

