/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.io;

import com.google.common.base.Charsets;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.streampipes.empire.cp.common.utils.io.ByteStreams2;
import org.streampipes.empire.cp.common.utils.io.DataOutputFunnel;

public final class DataOutputFunnels {
    private DataOutputFunnels() {
        throw new AssertionError();
    }

    public static <T extends Serializable> DataOutputFunnel<T, DataOutput> serializable() {
        return new SerializableFunnel();
    }

    private static final class SerializableFunnel<T extends Serializable>
    implements DataOutputFunnel<T, DataOutput> {
        private SerializableFunnel() {
        }

        @Override
        public void funnel(T theObj, DataOutput theTo) throws IOException {
            byte[] aBytes = ByteStreams2.toByteArray(theObj);
            theTo.writeInt(aBytes.length);
            theTo.write(aBytes);
        }
    }

    public static enum Primitives implements DataOutputFunnel
    {
        Int(new DataOutputFunnel(){

            public void funnel(Object theObj, DataOutput theTo) throws IOException {
                theTo.writeInt((Integer)theObj);
            }
        }),
        Long(new DataOutputFunnel(){

            public void funnel(Object theObj, DataOutput theTo) throws IOException {
                theTo.writeLong((Long)theObj);
            }
        }),
        Float(new DataOutputFunnel(){

            public void funnel(Object theObj, DataOutput theTo) throws IOException {
                theTo.writeFloat(((Float)theObj).floatValue());
            }
        }),
        String(new DataOutputFunnel(){

            public void funnel(Object theObj, DataOutput theTo) throws IOException {
                String aObj = (String)theObj;
                byte[] aBytes = aObj.getBytes(Charsets.UTF_8);
                theTo.writeInt(aBytes.length);
                theTo.write(aBytes);
            }
        });

        private final DataOutputFunnel mOutputWriter;

        private Primitives(DataOutputFunnel theOutputWriter) {
            this.mOutputWriter = theOutputWriter;
        }

        public void funnel(Object theObj, DataOutput theTo) throws IOException {
            this.mOutputWriter.funnel(theObj, theTo);
        }
    }
}

