/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class EncryptedFile
extends File {
    private transient Cipher mEncryptCipher;
    private transient Cipher mDecryptCipher;
    private static final byte[] IV = new byte[]{-113, 17, 64, -99, 2, 98, 111, 91};

    public EncryptedFile(String theFile, String theKey) throws IllegalStateException {
        this(theFile, EncryptedFile.makeGoodKey(theKey));
    }

    public EncryptedFile(URI theFileURI, String theKey) throws IllegalStateException {
        this(theFileURI, EncryptedFile.makeGoodKey(theKey));
    }

    public EncryptedFile(URI theFileURI, SecretKey theKey) throws IllegalStateException {
        super(theFileURI);
        this.initCiphers(theKey);
    }

    public EncryptedFile(String theFile, SecretKey theKey) throws IllegalStateException {
        super(theFile);
        this.initCiphers(theKey);
    }

    private void initCiphers(SecretKey theKey) {
        IvParameterSpec aSpec = new IvParameterSpec(IV);
        try {
            this.mEncryptCipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            this.mEncryptCipher.init(1, (Key)theKey, aSpec);
            this.mDecryptCipher = EncryptedFile.createDecryptCipher(theKey);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
    }

    public static InputStream decrypt(InputStream theStream, String theKey) throws IOException {
        return EncryptedFile.decrypt(theStream, EncryptedFile.makeGoodKey(theKey));
    }

    public static InputStream decrypt(InputStream theStream, SecretKey theKey) throws IOException {
        try {
            return new CipherInputStream(theStream, EncryptedFile.createDecryptCipher(theKey));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IOException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new IOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static OutputStream encrypt(OutputStream theStream, String theKey) throws IOException {
        return EncryptedFile.encrypt(theStream, EncryptedFile.makeGoodKey(theKey));
    }

    public static OutputStream encrypt(OutputStream theStream, SecretKey theKey) throws IOException {
        try {
            return new CipherOutputStream(theStream, EncryptedFile.createEncryptCipher(theKey));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IOException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new IOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            throw new IOException(e.getMessage());
        }
    }

    private static Cipher createDecryptCipher(SecretKey theKey) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher aCipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
        aCipher.init(2, (Key)theKey, new IvParameterSpec(IV));
        return aCipher;
    }

    private static Cipher createEncryptCipher(SecretKey theKey) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher aCipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
        aCipher.init(1, (Key)theKey, new IvParameterSpec(IV));
        return aCipher;
    }

    private static SecretKey makeGoodKey(String theKey) {
        String aKey = theKey;
        if (aKey.length() > 8) {
            aKey = aKey.substring(0, 8);
        } else if (aKey.length() < 8) {
            while (aKey.length() < 8) {
                aKey = aKey + "0";
            }
        }
        return new SecretKeySpec(aKey.getBytes(), "DES");
    }

    public InputStream getInputStream() throws IOException {
        return new CipherInputStream(new FileInputStream(this), this.mDecryptCipher);
    }

    public OutputStream getOutputStream() throws IOException {
        return new CipherOutputStream(new FileOutputStream(this), this.mEncryptCipher);
    }
}

