/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.io;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.streampipes.empire.cp.common.utils.base.Dates;

public final class Files2 {
    private Files2() {
        throw new AssertionError();
    }

    public static File classPath(String thePath) {
        try {
            return new File(Files2.class.getResource(thePath).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static String path(String theSegment, String ... theSegments) {
        return Joiner.on((char)File.pathSeparatorChar).skipNulls().join(null, (Object)theSegment, (Object[])theSegments);
    }

    public static File createDirectory(File theDirectory) throws IOException {
        if (theDirectory.exists()) {
            if (!theDirectory.isDirectory()) {
                Files2.deleteRecursively(theDirectory);
            }
        } else if (!theDirectory.mkdirs()) {
            throw new IOException("Unable to create directory " + theDirectory);
        }
        return theDirectory;
    }

    public static void deleteRecursively(File theFile) throws IOException {
        Preconditions.checkNotNull((Object)theFile);
        if (theFile.isDirectory() && theFile.getCanonicalPath().equals(theFile.getAbsolutePath())) {
            File[] aFiles = theFile.listFiles();
            if (aFiles == null) {
                throw new IOException("Error listing files for " + theFile);
            }
            for (File aFile : aFiles) {
                Files2.deleteRecursively(aFile);
            }
        }
        if (!theFile.delete()) {
            throw new IOException("Failed to delete file: " + theFile);
        }
    }

    public static List<File> listFiles(File theDirectory) {
        return Files2.listFiles(theDirectory, new FileFilter(){

            @Override
            public boolean accept(File theFile) {
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDirectory(File theDir, File theOutputFile) throws IOException {
        ZipOutputStream aZipOut = new ZipOutputStream(new FileOutputStream(theOutputFile));
        try {
            List<File> aFileList = Files2.listFiles(theDir);
            String aPathToRemove = theDir.getAbsolutePath().substring(0, theDir.getAbsolutePath().lastIndexOf(File.separator));
            for (File aFile : aFileList) {
                FileInputStream aFileIn = new FileInputStream(aFile);
                try {
                    ZipEntry aZipEntry = new ZipEntry(aFile.getAbsolutePath().substring(aFile.getAbsolutePath().indexOf(aPathToRemove) + aPathToRemove.length() + 1));
                    aZipOut.putNextEntry(aZipEntry);
                    ByteStreams.copy((InputStream)aFileIn, (OutputStream)aZipOut);
                }
                finally {
                    aZipOut.closeEntry();
                    Closeables.close((Closeable)aFileIn, (boolean)false);
                }
            }
        }
        finally {
            Closeables.close((Closeable)aZipOut, (boolean)false);
        }
    }

    public static List<File> listFiles(File theDirectory, FileFilter theFilter) {
        ArrayList<File> aList = new ArrayList<File>();
        if (!theDirectory.isDirectory()) {
            return aList;
        }
        File[] aFileList = theDirectory.listFiles();
        if (aFileList == null) {
            return aList;
        }
        for (File aFile : aFileList) {
            if (aFile.isDirectory()) {
                aList.addAll(Files2.listFiles(aFile, theFilter));
                continue;
            }
            if (!theFilter.accept(aFile)) continue;
            aList.add(aFile);
        }
        return aList;
    }

    public static void rotate(File theFile) throws IOException {
        String aDate = Dates.date(new Date(theFile.lastModified()));
        File aLogBk = new File(theFile.getParent(), theFile.getName() + "." + aDate);
        int aCount = 0;
        while (aLogBk.exists()) {
            aLogBk = new File(theFile.getParent(), theFile.getName() + "." + aDate + "." + aCount++);
        }
        Files.move((File)theFile, (File)aLogBk);
    }

    public static void copyDirectory(File theSource, File theDest) throws IOException {
        if (theSource.isDirectory()) {
            String[] aChildren;
            if (!theDest.exists() && !theDest.mkdir()) {
                throw new IOException("Could not create destination");
            }
            for (String aChild : aChildren = theSource.list()) {
                Files2.copyDirectory(new File(theSource, aChild), new File(theDest, aChild));
            }
        } else {
            Closer aCloser = Closer.create();
            FileInputStream in = new FileInputStream(theSource);
            FileOutputStream out = new FileOutputStream(theDest);
            aCloser.register((Closeable)in);
            aCloser.register((Closeable)out);
            ByteStreams.copy((InputStream)in, (OutputStream)out);
            aCloser.close();
        }
    }

    public static boolean deleteFiles(File theFile) {
        Preconditions.checkNotNull((Object)theFile);
        boolean aResult = true;
        if (theFile.isDirectory()) {
            for (File file : theFile.listFiles()) {
                if (!file.isFile()) continue;
                aResult = aResult && file.delete();
            }
        }
        return aResult;
    }
}

