/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.io;

import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MMapUtil {
    public static final Logger LOGGER;
    public static final boolean UNMAP_SUPPORTED;

    private MMapUtil() {
        throw new AssertionError();
    }

    public static final boolean unmap(final MappedByteBuffer theBuffer) {
        if (UNMAP_SUPPORTED) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        Method getCleanerMethod = theBuffer.getClass().getMethod("cleaner", new Class[0]);
                        getCleanerMethod.setAccessible(true);
                        Object cleaner = getCleanerMethod.invoke((Object)theBuffer, new Object[0]);
                        if (cleaner != null) {
                            cleaner.getClass().getMethod("clean", new Class[0]).invoke(cleaner, new Object[0]);
                        }
                        return null;
                    }
                });
                return true;
            }
            catch (PrivilegedActionException e) {
                LOGGER.warn("Cleaning memory mapped byte buffer failed", (Throwable)e);
            }
        }
        return false;
    }

    static {
        boolean v;
        LOGGER = LoggerFactory.getLogger(MMapUtil.class);
        try {
            Class.forName("sun.misc.Cleaner");
            Class.forName("java.nio.DirectByteBuffer").getMethod("cleaner", new Class[0]);
            v = true;
        }
        catch (Exception e) {
            v = false;
        }
        UNMAP_SUPPORTED = v;
        if (!UNMAP_SUPPORTED) {
            LOGGER.warn("JVM does not support unmapping memory-mapped files.");
        }
    }
}

