/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.io;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.streampipes.empire.cp.common.utils.io.FileRotationStrategy;

public final class TimeRotationStrategy
implements FileRotationStrategy {
    private final long mInterval;

    public TimeRotationStrategy(long theMilliseconds) {
        this.mInterval = theMilliseconds;
    }

    @Override
    public boolean needsRotation(File theFile) {
        return this.needsRotation(theFile.lastModified(), System.currentTimeMillis());
    }

    public long getInterval() {
        return this.mInterval;
    }

    @VisibleForTesting
    public boolean needsRotation(long theLastModifiedTime, long theTime) {
        long now = theTime / this.mInterval;
        long lastWrite = theLastModifiedTime / this.mInterval;
        return now > lastWrite;
    }

    public static TimeRotationStrategy create(String theInterval) {
        return new TimeRotationStrategy(TimeRotationStrategy.parseDH(theInterval));
    }

    private static long parseDH(String theStr) {
        int aLastIndex = theStr.length() - 1;
        TimeUnit aUnit = TimeRotationStrategy.getTimeUnit(theStr.charAt(aLastIndex));
        return TimeRotationStrategy.parseDuration(theStr.substring(0, aLastIndex), aUnit);
    }

    private static TimeUnit getTimeUnit(char theCh) {
        switch (Character.toLowerCase(theCh)) {
            case 'd': {
                return TimeUnit.DAYS;
            }
            case 'h': {
                return TimeUnit.HOURS;
            }
        }
        throw new IllegalArgumentException();
    }

    private static long parseHMS(String theStr) {
        String[] theFields = theStr.split("\\:");
        if (theFields.length != 3) {
            throw new IllegalArgumentException();
        }
        return TimeRotationStrategy.parseDuration(theFields[0], TimeUnit.HOURS) + TimeRotationStrategy.parseDuration(theFields[1], TimeUnit.MINUTES) + TimeRotationStrategy.parseDuration(theFields[2], TimeUnit.SECONDS);
    }

    private static long parseDuration(String theStr, TimeUnit theUnit) {
        int aVal = Integer.parseInt(theStr);
        if (aVal < 0) {
            throw new IllegalArgumentException();
        }
        return theUnit.toMillis(aVal);
    }
}

