/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.timer;

import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.streampipes.empire.cp.common.utils.timer.TableData;
import org.streampipes.empire.cp.common.utils.timer.Timer;
import org.streampipes.empire.cp.common.utils.util.AlphaNumericComparator;

public class Timers {
    private Map<String, Timer> timers = new LinkedHashMap<String, Timer>();
    public final Timer mainTimer = this.createTimer("main");

    public Timers() {
        this.mainTimer.start();
    }

    public void addAll(Timers other) {
        for (Map.Entry<String, Timer> entry : other.timers.entrySet()) {
            String name = entry.getKey();
            Timer otherTimer = entry.getValue();
            Timer thisTimer = this.getTimer(name);
            if (thisTimer == null) {
                this.timers.put(name, otherTimer);
                continue;
            }
            thisTimer.add(otherTimer);
        }
    }

    public Timer createTimer(String name) {
        if (this.timers.containsKey(name)) {
            return this.timers.get(name);
        }
        Timer t = new Timer(name, this.mainTimer);
        this.timers.put(name, t);
        return t;
    }

    public Timer startTimer(String name) {
        Timer t = this.getTimer(name);
        if (t == null) {
            t = this.createTimer(name);
        }
        t.start();
        return t;
    }

    public void checkTimer(String name) throws Exception {
        Timer t = this.getTimer(name);
        if (t == null) {
            throw new UnsupportedOperationException("Timer " + name + " does not exist!");
        }
        t.check();
    }

    public void resetTimer(String name) {
        Timer t = this.getTimer(name);
        if (t == null) {
            throw new UnsupportedOperationException("Timer " + name + " does not exist!");
        }
        t.reset();
    }

    public void interrupt() {
        this.mainTimer.interrupt();
    }

    public void setTimeout(String name, long timeout) {
        Timer t = this.getTimer(name);
        if (t == null) {
            t = this.createTimer(name);
        }
        t.setTimeout(timeout);
    }

    public void stopTimer(String name) {
        Timer t = this.getTimer(name);
        if (t == null) {
            throw new UnsupportedOperationException("Timer " + name + " does not exist!");
        }
        t.stop();
    }

    public void resetAll() {
        for (Timer timer : this.timers.values()) {
            timer.reset();
        }
        this.mainTimer.start();
    }

    public long getTimerTotal(String name) {
        Timer timer = this.getTimer(name);
        return timer == null ? 0L : timer.getTotal();
    }

    public double getTimerAverage(String name) {
        Timer timer = this.getTimer(name);
        return timer == null ? 0.0 : timer.getAverage();
    }

    public Timer getTimer(String name) {
        return this.timers.get(name);
    }

    public Collection<Timer> getTimers() {
        return this.timers.values();
    }

    public void print() {
        this.print(false);
    }

    public void print(Writer pw) {
        this.print(pw, false, "Total");
    }

    public void print(boolean shortForm) {
        this.print(shortForm, "Total");
    }

    public void print(boolean shortForm, String sortBy) {
        this.print(new PrintWriter(System.out), shortForm, sortBy);
    }

    public void print(Writer pw, boolean shortForm, final String sortBy) {
        boolean[] blArray;
        String[] stringArray;
        if (shortForm) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "Name";
            stringArray = stringArray2;
            stringArray2[1] = "Total (ms)";
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "Name";
            stringArray3[1] = "Count";
            stringArray3[2] = "Avg";
            stringArray = stringArray3;
            stringArray3[3] = "Total (ms)";
        }
        String[] colNames = stringArray;
        if (shortForm) {
            boolean[] blArray2 = new boolean[2];
            blArray2[0] = false;
            blArray = blArray2;
            blArray2[1] = true;
        } else {
            boolean[] blArray3 = new boolean[4];
            blArray3[0] = false;
            blArray3[1] = true;
            blArray3[2] = true;
            blArray = blArray3;
            blArray3[3] = true;
        }
        boolean[] alignment = blArray;
        ArrayList<Timer> list = new ArrayList<Timer>(this.timers.values());
        if (sortBy != null) {
            Collections.sort(list, new Comparator<Timer>(){

                @Override
                public int compare(Timer o1, Timer o2) {
                    if (sortBy.equalsIgnoreCase("Total")) {
                        long t1 = o1.getTotal();
                        long t2 = o2.getTotal();
                        if (t1 == 0L) {
                            t1 = o1.getElapsed();
                        }
                        if (t2 == 0L) {
                            t2 = o2.getElapsed();
                        }
                        return (int)(t2 - t1);
                    }
                    if (sortBy.equalsIgnoreCase("Avg")) {
                        return (int)(o2.getAverage() - o1.getAverage());
                    }
                    if (sortBy.equalsIgnoreCase("Count")) {
                        return (int)(o2.getCount() - o1.getCount());
                    }
                    return AlphaNumericComparator.CASE_INSENSITIVE.compare(o1, o2);
                }
            });
        }
        DecimalFormat nf = new DecimalFormat("0.00000");
        TableData table = new TableData(Arrays.asList(colNames));
        table.setAlignment(alignment);
        for (Timer timer : list) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(timer.getName());
            if (!shortForm) {
                row.add(String.valueOf(timer.getCount()));
                row.add(nf.format(timer.getAverage()));
            }
            row.add(String.valueOf(timer.getTotal() + timer.getElapsed()));
            table.add(row);
        }
        table.print(pw);
    }

    public String toString() {
        return this.timers.values().toString();
    }
}

