/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.base;

import com.google.common.collect.Maps;
import java.util.Map;
import org.streampipes.empire.cp.common.utils.base.DataKey;

public class DataMap {
    private final Map<DataKey<Object>, Object> data = Maps.newHashMap();

    private DataMap() {
    }

    public static DataMap of() {
        return new DataMap();
    }

    public static <V> DataMap of(DataKey<V> key, V value) {
        return DataMap.of().set(key, value);
    }

    public static <V1, V2> DataMap of(DataKey<V1> key1, V1 value1, DataKey<V2> key2, V2 value2) {
        return DataMap.of().set(key1, value1).set(key2, value2);
    }

    public static <V1, V2, V3> DataMap of(DataKey<V1> key1, V1 value1, DataKey<V2> key2, V2 value2, DataKey<V3> key3, V3 value3) {
        return DataMap.of().set(key1, value1).set(key2, value2).set(key3, value3);
    }

    public <V> V get(DataKey<V> key) {
        return (V)this.data.get(key);
    }

    public <V> DataMap set(DataKey<V> key, V value) {
        this.data.put(key, value);
        return this;
    }

    public <V> boolean contains(DataKey<V> key) {
        return this.data.containsKey(key);
    }

    public <V> V remove(DataKey<V> key) {
        return (V)this.data.remove(key);
    }
}

