/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.base;

import com.google.common.base.Preconditions;

public final class Option<V> {
    private final String name;
    private V defaultValue;

    protected Option(String name, V defaultValue) {
        Preconditions.checkNotNull((Object)name);
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public static <T> Option<T> create(String name) {
        return new Option<Object>(name, null);
    }

    public static <T> Option<T> create(String name, T defaultValue) {
        return new Option<T>(name, defaultValue);
    }

    public V getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(V defaultValue) {
        this.defaultValue = defaultValue;
    }

    public int hashCode() {
        return 17 * this.name.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof Option && this.name.equals(((Option)other).name);
    }

    public String toString() {
        return this.name;
    }
}

