/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.base;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.streampipes.empire.cp.common.utils.base.Copyable;
import org.streampipes.empire.cp.common.utils.base.Option;

public class Options
implements Iterable<Option<Object>>,
Copyable<Options> {
    private static Options EMPTY = new Options(Collections.emptyMap());
    private final Map<Option<Object>, Object> options;

    Options() {
        this(Maps.newHashMap());
    }

    Options(Options theOptions) {
        this(theOptions.options);
    }

    private Options(Map<Option<Object>, Object> theMap) {
        this.options = theMap;
    }

    @Override
    public Iterator<Option<Object>> iterator() {
        return this.options.keySet().iterator();
    }

    @Override
    public Options copy() {
        return new Options(Maps.newHashMap(this.options));
    }

    public static Options create() {
        return new Options();
    }

    public static <V> Options of(Option<V> key, V value) {
        return Options.create().set(key, value);
    }

    public static <V1, V2> Options of(Option<V1> key1, V1 value1, Option<V2> key2, V2 value2) {
        return Options.create().set(key1, value1).set(key2, value2);
    }

    public static <V1, V2, V3> Options of(Option<V1> key1, V1 value1, Option<V2> key2, V2 value2, Option<V3> key3, V3 value3) {
        return Options.create().set(key1, value1).set(key2, value2).set(key3, value3);
    }

    public <V> boolean contains(Option<V> option) {
        return this.options.containsKey(option);
    }

    public <V> V get(Option<V> option) {
        Object value = this.options.get(option);
        return (V)(value != null ? value : option.getDefaultValue());
    }

    public boolean is(Option<Boolean> option) {
        Boolean value = (Boolean)this.options.get(option);
        if (value == null) {
            value = option.getDefaultValue();
        }
        return value != null && value != false;
    }

    public <V> Options set(Option<V> option, V value) {
        this.options.put(option, value);
        return this;
    }

    public Options setAll(Options theOptions) {
        this.options.putAll(theOptions.options);
        return this;
    }

    public <V> V remove(Option<V> option) {
        Object oldValue = this.options.remove(option);
        return (V)(oldValue != null ? oldValue : option.getDefaultValue());
    }

    public static void insert(Options theOptions, Options theOptionsToInsert) {
        for (Option<Object> aOpt : theOptionsToInsert) {
            if (theOptions.contains(aOpt)) continue;
            theOptions.set(aOpt, theOptionsToInsert.get(aOpt));
        }
    }

    public static Options combine(Options ... theOptionsArray) {
        Options aResult = Options.create();
        for (Options aOptions : theOptionsArray) {
            aResult.setAll(aOptions);
        }
        return aResult;
    }

    public static Options unmodifiable(Options options) {
        return new Options(Collections.unmodifiableMap(options.options));
    }

    public static Options empty() {
        return EMPTY;
    }

    public static <V> Options singleton(Option<V> key, V value) {
        return new Options(Collections.singletonMap(key, value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Options aOptions = (Options)o;
        return Objects.equal(this.options, aOptions.options);
    }

    public int hashCode() {
        return this.options != null ? this.options.hashCode() : 0;
    }

    public String toString() {
        return this.options.toString();
    }

    public int size() {
        return this.options.size();
    }
}

