/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.base;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemUtil.class);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private SystemUtil() {
        throw new AssertionError();
    }

    public static boolean getPropertyAsBoolean(String theProperty, boolean theDefault) {
        String aValue = System.getProperty(theProperty);
        if (aValue == null) {
            return theDefault;
        }
        try {
            return Boolean.parseBoolean(aValue);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Value for property {} is intended to be an boolean, but the provided value {} is not a valid boolean", (Object)theProperty, (Object)theDefault);
            return theDefault;
        }
    }

    public static int getPropertyAsInt(String theProperty, int theDefault) {
        String aValue = System.getProperty(theProperty);
        if (aValue == null) {
            return theDefault;
        }
        try {
            return Integer.parseInt(aValue);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Value for property {} is intended to be an integer, but the provided value {} is not a valid integer", (Object)theProperty, (Object)theDefault);
            return theDefault;
        }
    }

    public static long getPropertyAsLong(String theProperty, long theDefault) {
        String aValue = System.getProperty(theProperty);
        if (aValue == null) {
            return theDefault;
        }
        try {
            return Long.parseLong(aValue);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Value for property {} is intended to be an long, but the provided value {} is not a valid long", (Object)theProperty, (Object)theDefault);
            return theDefault;
        }
    }

    public static float getPropertyAsFloat(String theProperty, float theDefault) {
        String aValue = System.getProperty(theProperty);
        if (aValue == null) {
            return theDefault;
        }
        try {
            return Float.parseFloat(aValue);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Value for property {} is intended to be an float, but the provided value {} is not a valid float", (Object)theProperty, (Object)Float.valueOf(theDefault));
            return theDefault;
        }
    }

    public static double getPropertyAsDouble(String theProperty, double theDefault) {
        String aValue = System.getProperty(theProperty);
        if (aValue == null) {
            return theDefault;
        }
        try {
            return Double.parseDouble(aValue);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Value for property {} is intended to be an double, but the provided value {} is not a valid double", (Object)theProperty, (Object)theDefault);
            return theDefault;
        }
    }

    public static String getProperty(String theProperty, String theDefault) {
        String aValue = System.getProperty(theProperty);
        if (aValue != null) {
            return aValue;
        }
        return theDefault;
    }
}

