/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.collect;

import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class BigArrayList<T>
implements Iterable<T> {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_MAX_SIZE = 0x7FFFFFFE;
    private BigList<T> data = new SingleList();
    private boolean singleData = true;
    private final int maxSize;

    public BigArrayList() {
        this(0x7FFFFFFE);
    }

    BigArrayList(int maxSize) {
        this.maxSize = maxSize;
    }

    public static <T> BigArrayList<T> create() {
        return new BigArrayList<T>();
    }

    public static <T> BigArrayList<T> create(int maxSize) {
        return new BigArrayList<T>(maxSize);
    }

    public T get(long index) {
        return this.data.get(index);
    }

    public T set(long theIndex, T theElem) {
        return this.data.set(theIndex, theElem);
    }

    public boolean add(T element) {
        if (this.singleData && this.data.size() >= (long)this.maxSize) {
            this.data = new MultiList((SingleList)this.data);
            this.singleData = false;
        }
        return this.data.add(element);
    }

    public long size() {
        return this.data.size();
    }

    public void clear() {
        this.data.clear();
        this.singleData = true;
    }

    @Override
    public Iterator<T> iterator() {
        return this.data.iterator();
    }

    private class MultiList
    implements BigList<T> {
        private List<List<T>> data = new ArrayList();
        private transient List<T> currList;
        private long size;

        public MultiList() {
            this.size = 0L;
            this.grow();
        }

        public MultiList(SingleList otherData) {
            this.data.add(otherData.data);
            this.size = otherData.size();
            this.grow();
        }

        @Override
        public void clear() {
            this.data = new ArrayList();
            this.size = 0L;
            this.grow();
        }

        @Override
        public T get(long index) {
            int pos = (int)(index / (long)BigArrayList.this.maxSize);
            int offset = (int)(index - (long)pos * (long)BigArrayList.this.maxSize);
            return this.data.get(pos).get(offset);
        }

        @Override
        public T set(long theIndex, T theElement) {
            int pos = (int)(theIndex / (long)BigArrayList.this.maxSize);
            int offset = (int)(theIndex - (long)pos * (long)BigArrayList.this.maxSize);
            while (pos > this.data.size() - 1) {
                this.grow();
            }
            return this.data.get(pos).set(offset, theElement);
        }

        @Override
        public boolean add(T element) {
            if (this.currList.size() == BigArrayList.this.maxSize) {
                this.grow();
            }
            if (this.currList.add(element)) {
                ++this.size;
                return true;
            }
            return false;
        }

        @Override
        public long size() {
            return this.size;
        }

        private void grow() {
            this.currList = new ArrayList();
            this.data.add(this.currList);
        }

        @Override
        public Iterator<T> iterator() {
            return new UnmodifiableIterator<T>(){
                private final Iterator<List<T>> lists;
                private Iterator<T> iter;
                {
                    this.lists = MultiList.this.data.iterator();
                    this.iter = this.lists.next().iterator();
                }

                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                public T next() {
                    Object next = this.iter.next();
                    if (!this.iter.hasNext() && this.lists.hasNext()) {
                        this.iter = this.lists.next().iterator();
                    }
                    return next;
                }
            };
        }
    }

    private class SingleList
    implements BigList<T> {
        private List<T> data = new ArrayList();

        @Override
        public void clear() {
            this.data.clear();
        }

        @Override
        public T get(long index) {
            return this.data.get((int)index);
        }

        @Override
        public boolean add(T element) {
            return this.data.add(element);
        }

        @Override
        public long size() {
            return this.data.size();
        }

        @Override
        public T set(long theIndex, T theElement) {
            if (theIndex + 1L > (long)this.data.size()) {
                ((ArrayList)this.data).ensureCapacity((int)theIndex + 1);
                while (theIndex + 1L > (long)this.data.size()) {
                    this.data.add(null);
                }
            }
            return this.data.set((int)theIndex, theElement);
        }

        @Override
        public Iterator<T> iterator() {
            return this.data.iterator();
        }
    }

    private static interface BigList<K>
    extends Iterable<K> {
        public K get(long var1);

        public boolean add(K var1);

        public long size();

        public K set(long var1, K var3);

        public void clear();
    }
}

