/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.collect;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DisjointSet<T> {
    private Map<T, Node<T>> elements = new HashMap<T, Node<T>>();

    public void add(T o) {
        if (this.elements.containsKey(o)) {
            return;
        }
        this.elements.put(o, new Node<T>(o));
    }

    public boolean contains(T o) {
        return this.elements.containsKey(o);
    }

    public Collection<T> elements() {
        return Collections.unmodifiableSet(this.elements.keySet());
    }

    public T find(T o) {
        return (T)this.findRoot(o).object;
    }

    private Node<T> findRoot(T o) {
        Node<Object> node = this.elements.get(o);
        while (node.parent.parent != node.parent) {
            node.parent = node.parent.parent;
            node = node.parent;
        }
        return node.parent;
    }

    public Collection<Set<T>> getEquivalanceSets() {
        HashMap<T, HashSet<T>> equivalanceSets = new HashMap<T, HashSet<T>>();
        for (T x : this.elements.keySet()) {
            T representative = this.find(x);
            HashSet<T> equivalanceSet = (HashSet<T>)equivalanceSets.get(representative);
            if (equivalanceSet == null) {
                equivalanceSet = new HashSet<T>();
                equivalanceSets.put(representative, equivalanceSet);
            }
            equivalanceSet.add(x);
        }
        return equivalanceSets.values();
    }

    public boolean isSame(T x, T y) {
        return this.find(x).equals(this.find(y));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        Iterator<Node<T>> i = this.elements.values().iterator();
        while (i.hasNext()) {
            Node<T> node = i.next();
            buffer.append(node.object);
            buffer.append(" -> ");
            buffer.append(node.parent.object);
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}");
        return buffer.toString();
    }

    public Node<T> union(T x, T y) {
        Node<T> rootX = this.findRoot(x);
        Node<T> rootY = this.findRoot(y);
        if (rootX.rank > rootY.rank) {
            Node<T> node = rootX;
            rootX = rootY;
            rootY = node;
        } else if (rootX.rank == rootY.rank) {
            ++rootY.rank;
        }
        rootX.parent = rootY;
        return rootY;
    }

    private class Node<U> {
        U object;
        Node<U> parent = this;
        int rank = 0;

        Node(U o) {
            this.object = o;
        }
    }
}

