/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.hash;

import com.google.common.base.Charsets;
import com.google.common.hash.Funnel;
import com.google.common.hash.Hasher;
import com.google.common.hash.PrimitiveSink;
import java.nio.charset.Charset;

public abstract class AbstractHasher
implements Hasher {
    public Hasher putBoolean(boolean b) {
        return this.putByte(b ? (byte)1 : 0);
    }

    public Hasher putDouble(double d) {
        return this.putLong(Double.doubleToRawLongBits(d));
    }

    public Hasher putFloat(float f) {
        return this.putInt(Float.floatToRawIntBits(f));
    }

    public Hasher putBytes(byte[] theBytes) {
        return this.putBytes(theBytes, 0, theBytes.length);
    }

    public Hasher putString(CharSequence theCharSequence, Charset theCharset) {
        return this.putBytes(theCharSequence.toString().getBytes(theCharset));
    }

    public Hasher putUnencodedChars(CharSequence theCharSequence) {
        return this.putString(theCharSequence, Charsets.UTF_8);
    }

    public <T> Hasher putObject(T theT, Funnel<? super T> theFunnel) {
        theFunnel.funnel(theT, (PrimitiveSink)this);
        return this;
    }
}

