/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.hash;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.PrimitiveSink;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;

public final class ConcatenatedPrimitiveSink<T extends PrimitiveSink>
implements PrimitiveSink,
Iterable<T> {
    private final ImmutableList<T> mSinks;

    public ConcatenatedPrimitiveSink(T theSink, T ... theOtherSinks) {
        this.mSinks = ImmutableList.builder().add(theSink).add((Object[])theOtherSinks).build();
    }

    public ConcatenatedPrimitiveSink(List<T> theSinks) {
        this.mSinks = ImmutableList.copyOf(theSinks);
    }

    public ImmutableList<T> getSinks() {
        return this.mSinks;
    }

    @Override
    public Iterator<T> iterator() {
        return this.mSinks.iterator();
    }

    public PrimitiveSink putBoolean(boolean theBool) {
        for (PrimitiveSink aSink : this) {
            aSink.putBoolean(theBool);
        }
        return this;
    }

    public PrimitiveSink putByte(byte theByte) {
        for (PrimitiveSink aSink : this) {
            aSink.putByte(theByte);
        }
        return this;
    }

    public PrimitiveSink putBytes(byte[] theBytes) {
        return this.putBytes(theBytes, 0, theBytes.length);
    }

    public PrimitiveSink putBytes(byte[] theBytes, int theOffset, int theLength) {
        for (int i = 0; i < theLength; ++i) {
            this.putByte(theBytes[theOffset + i]);
        }
        return this;
    }

    public PrimitiveSink putShort(short theShort) {
        for (PrimitiveSink aSink : this) {
            aSink.putShort(theShort);
        }
        return this;
    }

    public PrimitiveSink putInt(int theInt) {
        for (PrimitiveSink aSink : this) {
            aSink.putInt(theInt);
        }
        return this;
    }

    public PrimitiveSink putLong(long theLong) {
        for (PrimitiveSink aSink : this) {
            aSink.putLong(theLong);
        }
        return this;
    }

    public PrimitiveSink putFloat(float theFloat) {
        for (PrimitiveSink aSink : this) {
            aSink.putFloat(theFloat);
        }
        return this;
    }

    public PrimitiveSink putDouble(double theDouble) {
        for (PrimitiveSink aSink : this) {
            aSink.putDouble(theDouble);
        }
        return this;
    }

    public PrimitiveSink putChar(char theChar) {
        for (PrimitiveSink aSink : this) {
            aSink.putChar(theChar);
        }
        return this;
    }

    public PrimitiveSink putUnencodedChars(CharSequence theCharSequence) {
        return this.putString(theCharSequence, Charsets.UTF_8);
    }

    public PrimitiveSink putString(CharSequence theCharSequence, Charset theCharset) {
        return this.putBytes(theCharSequence.toString().getBytes(theCharset));
    }
}

