/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.io;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import com.google.common.primitives.Ints;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public final class ByteStreams2 {
    private ByteStreams2() {
        throw new AssertionError();
    }

    public static byte[] toByteArray(Object theObj) throws IOException {
        ByteArrayOutputStream aByteOutput = new ByteArrayOutputStream();
        ObjectOutputStream aObjOut = new ObjectOutputStream(aByteOutput);
        aObjOut.writeObject(theObj);
        aObjOut.flush();
        return aByteOutput.toByteArray();
    }

    public static <T> T fromByteArray(byte[] theBytes) throws IOException, ClassNotFoundException, ClassCastException {
        return (T)new ObjectInputStream(new ByteArrayInputStream(theBytes)).readObject();
    }

    public static int readInt(InputStream theStream) throws IOException {
        byte[] array = new byte[4];
        ByteStreams.readFully((InputStream)theStream, (byte[])array);
        return Ints.fromByteArray((byte[])array);
    }

    public static void writeInt(OutputStream theStream, int theInt) throws IOException {
        theStream.write((byte)(theInt >> 24));
        theStream.write((byte)(theInt >> 16));
        theStream.write((byte)(theInt >> 8));
        theStream.write((byte)theInt);
    }

    public static void writeLong(OutputStream theStream, long theLong) throws IOException {
        theStream.write((byte)(theLong >> 56));
        theStream.write((byte)(theLong >> 48));
        theStream.write((byte)(theLong >> 40));
        theStream.write((byte)(theLong >> 32));
        theStream.write((byte)(theLong >> 24));
        theStream.write((byte)(theLong >> 16));
        theStream.write((byte)(theLong >> 8));
        theStream.write((byte)theLong);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gzip(byte[] theBytes) throws IOException {
        ByteArrayOutputStream aOut = new ByteArrayOutputStream(theBytes.length);
        GZIPOutputStream aZipped = new GZIPOutputStream(aOut);
        ByteArrayInputStream aIn = new ByteArrayInputStream(theBytes);
        Closer aCloser = Closer.create();
        aCloser.register((Closeable)aZipped);
        aCloser.register((Closeable)aIn);
        try {
            ByteStreams.copy((InputStream)aIn, (OutputStream)aZipped);
        }
        finally {
            aCloser.close();
        }
        return aOut.toByteArray();
    }
}

