/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.io;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.streampipes.empire.cp.common.utils.io.DataInputProcessor;
import org.streampipes.empire.cp.common.utils.io.DataInputToInputStreamAdapter;

public final class DataInputProcessors {
    private DataInputProcessors() {
        throw new AssertionError();
    }

    public static <T extends Serializable> DataInputProcessor<T, DataInput> serializable() {
        return new SerializableDataInputProcessor();
    }

    public static <T extends Serializable> DataInputProcessor<T, DataInput> serializable(Function<InputStream, ObjectInputStream> theStreamFunction) {
        return new SerializableDataInputProcessor(theStreamFunction);
    }

    private static class SerializableDataInputProcessor<T extends Serializable>
    implements DataInputProcessor<T, DataInput> {
        private final Function<InputStream, ObjectInputStream> mStreamFunction;

        private SerializableDataInputProcessor() {
            this(new Function<InputStream, ObjectInputStream>(){

                public ObjectInputStream apply(InputStream theInputStream) {
                    try {
                        return new ObjectInputStream(theInputStream);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public SerializableDataInputProcessor(Function<InputStream, ObjectInputStream> theStreamFunction) {
            this.mStreamFunction = (Function)Preconditions.checkNotNull(theStreamFunction);
        }

        @Override
        public T processInput(DataInput theInput) throws IOException {
            try {
                return (T)((Serializable)((ObjectInputStream)this.mStreamFunction.apply((Object)DataInputToInputStreamAdapter.create(theInput))).readObject());
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Malformed object", e);
            }
            catch (RuntimeException e) {
                throw new IOException("Unable to construct stream", e);
            }
        }
    }

    public static enum Primitives implements DataInputProcessor
    {
        Int(new DataInputProcessor<Integer, DataInput>(){

            @Override
            public Integer processInput(DataInput theInput) throws IOException {
                return theInput.readInt();
            }
        }),
        Long(new DataInputProcessor<Long, DataInput>(){

            @Override
            public Long processInput(DataInput theInput) throws IOException {
                return theInput.readLong();
            }
        }),
        Float(new DataInputProcessor<Float, DataInput>(){

            @Override
            public Float processInput(DataInput theInput) throws IOException {
                return java.lang.Float.valueOf(theInput.readFloat());
            }
        }),
        String(new DataInputProcessor<String, DataInput>(){

            @Override
            public String processInput(DataInput theInput) throws IOException {
                byte[] aBytes = new byte[theInput.readInt()];
                theInput.readFully(aBytes);
                return new String(aBytes, Charsets.UTF_8);
            }
        });

        private final DataInputProcessor mInputProcessor;

        private Primitives(DataInputProcessor theInputProcessor) {
            this.mInputProcessor = (DataInputProcessor)Preconditions.checkNotNull((Object)theInputProcessor);
        }

        public Object processInput(DataInput theInput) throws IOException {
            return this.mInputProcessor.processInput(theInput);
        }
    }
}

