/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.io;

import com.google.common.base.Preconditions;
import java.io.File;
import org.streampipes.empire.cp.common.utils.io.FileRotationStrategy;

public final class SizeRotationStrategy
implements FileRotationStrategy {
    private final long mMaxSize;

    public SizeRotationStrategy(long theMaxSize) {
        Preconditions.checkArgument((theMaxSize > 0L ? 1 : 0) != 0);
        this.mMaxSize = theMaxSize;
    }

    public long getMaxSize() {
        return this.mMaxSize;
    }

    @Override
    public boolean needsRotation(File theFile) {
        return theFile.length() > this.mMaxSize;
    }
}

