/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public final class CustomizableJULFormatter
extends Formatter {
    private static final DateFormat SHORT_TIME_FORMAT = new SimpleDateFormat("hh:mm:ss.SSS");
    private static final DateFormat LONG_TIME_FORMAT = new SimpleDateFormat("MMM d, yyyy hh:mm:ss.SSS");
    private static final String NEW_LINE = System.getProperty("line.separator");
    private Style style = Style.SHORT;
    private ThreadStyle threadStyle = null;

    private CustomizableJULFormatter(Style style) {
        this.style = style;
    }

    public CustomizableJULFormatter() {
        String stylePropName = this.getClass().getName() + ".style";
        String style = LogManager.getLogManager().getProperty(stylePropName);
        try {
            this.style = Style.valueOf(style.toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String threadsPropName = this.getClass().getName() + ".threads";
        String threadStyle = LogManager.getLogManager().getProperty(threadsPropName);
        try {
            this.threadStyle = ThreadStyle.valueOf(threadStyle.toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        if (this.style != Style.NONE) {
            sb.append("[");
            sb.append(record.getLevel());
            sb.append(" ");
            if (this.threadStyle != null) {
                sb.append("(Thread: ");
                if (this.threadStyle == ThreadStyle.ID) {
                    sb.append(record.getThreadID());
                } else {
                    sb.append(Thread.currentThread().getName());
                }
                sb.append(") ");
            }
            if (this.style != Style.SHORT) {
                if (this.style != Style.LONG) {
                    sb.append(this.simpleClassName(record.getSourceClassName()));
                } else {
                    sb.append(record.getSourceClassName());
                }
                sb.append(".");
                sb.append(record.getSourceMethodName());
                sb.append(" - ");
            }
            if (this.style != Style.LONG) {
                sb.append(SHORT_TIME_FORMAT.format(record.getMillis()));
            } else {
                sb.append(LONG_TIME_FORMAT.format(record.getMillis()));
            }
            sb.append("] ");
        }
        sb.append(record.getMessage());
        if (record.getThrown() != null) {
            try {
                sb.append(NEW_LINE);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        sb.append(NEW_LINE);
        return sb.toString();
    }

    private String simpleClassName(String s) {
        return s == null ? "?" : s.substring(s.lastIndexOf(".") + 1);
    }

    public static void main(String[] args) {
        for (Style style : Style.values()) {
            LogRecord record = new LogRecord(Level.FINE, "This message is formatted with style " + (Object)((Object)style));
            record.setSourceClassName("com.example.FormatExample");
            record.setSourceMethodName("print");
            CustomizableJULFormatter formatter = new CustomizableJULFormatter(style);
            System.out.print(formatter.format(record));
        }
    }

    private static enum ThreadStyle {
        ID,
        NAME;

    }

    private static enum Style {
        NONE,
        SHORT,
        MEDIUM,
        LONG;

    }
}

