/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.nio.file;

import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;

public final class Paths2 {
    private Paths2() {
        throw new AssertionError();
    }

    public static String toString(Path thePath, Charset theCharset) throws IOException {
        return new String(Files.readAllBytes(thePath), theCharset);
    }

    public static Path withJarFileSystem(String thePath, Class<?> theClass) {
        try {
            String aUri = Resources.getResource(theClass, (String)thePath).toURI().toString();
            String[] aSplit = aUri.split("!");
            FileSystem aFs = FileSystems.newFileSystem(URI.create(aSplit[0]), Maps.newHashMap());
            return aFs.getPath(aSplit[1], new String[0]);
        }
        catch (IOException | URISyntaxException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static Path classPath(String thePath) {
        try {
            return Paths.get(Paths2.class.getResource(thePath).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteSource asByteSource(final Path thePath) {
        return new ByteSource(){

            public InputStream openStream() throws IOException {
                return Files.newInputStream(thePath, new OpenOption[0]);
            }
        };
    }

    public static void deleteOnExit(final Path thePath) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Paths2.delete(thePath);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void delete(Path thePath) throws IOException {
        if (Files.isDirectory(thePath, new LinkOption[0])) {
            Paths2.delete(thePath, true);
        } else {
            Files.deleteIfExists(thePath);
        }
    }

    public static void deleteContents(Path thePath) throws IOException {
        Paths2.delete(thePath, false);
    }

    private static void delete(final Path thePath, final boolean theDeleteRoot) throws IOException {
        if (Files.exists(thePath, new LinkOption[0])) {
            Files.walkFileTree(thePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path theDir, IOException theException) throws IOException {
                    if (!theDir.equals(thePath) || theDir.equals(thePath) && theDeleteRoot) {
                        Files.deleteIfExists(theDir);
                    }
                    return super.postVisitDirectory(theDir, theException);
                }

                @Override
                public FileVisitResult visitFile(Path theFile, BasicFileAttributes theAttrs) throws IOException {
                    Files.deleteIfExists(theFile);
                    return super.visitFile(theFile, theAttrs);
                }
            });
        }
    }

    public static void write(String theInput, Path theFile, Charset theCharset) throws IOException {
        try (OutputStream aOut = Files.newOutputStream(theFile, new OpenOption[0]);){
            aOut.write(theInput.getBytes(theCharset));
        }
    }

    public static Path createTempDir() {
        int TEMP_DIR_ATTEMPTS = 10;
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < TEMP_DIR_ATTEMPTS; ++counter) {
            try {
                return Files.createTempDirectory(baseName + counter, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        throw new IllegalStateException("Failed to create directory within " + TEMP_DIR_ATTEMPTS + " attempts (tried " + baseName + "0 to " + baseName + (TEMP_DIR_ATTEMPTS - 1) + ')');
    }

    public static Stream<Path> list(Path theFile) {
        try {
            return Files.list(theFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static long size(Path theFile) {
        try {
            return Files.size(theFile);
        }
        catch (IOException e) {
            return 0L;
        }
    }
}

