/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.common.utils.util;

import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.streampipes.empire.cp.common.utils.io.Files2;

public class ClassPath {
    public static final boolean QUIET = true;
    private static Collection<Class> mClasses;
    private static MutableURLClassLoader mLoader;

    public static Collection<Class> instantiableClasses(Class<?> theClass) {
        return Collections2.filter(ClassPath.classes(theClass), theClass1 -> !theClass1.isInterface() && !Modifier.isAbstract(theClass1.getModifiers()));
    }

    public static Collection<Class> classes(Class<?> theInterface) {
        return Collections2.filter(ClassPath.classes(), theInterface::isAssignableFrom);
    }

    public static void add(URL ... theURL) {
        HashSet newURLS;
        HashSet curr = Sets.newHashSet((Object[])mLoader.getURLs());
        if (!Sets.intersection((Set)curr, (Set)(newURLS = Sets.newHashSet((Object[])theURL))).isEmpty()) {
            curr.removeAll(newURLS);
            mLoader = new MutableURLClassLoader(curr.toArray(new URL[curr.size()]), mLoader.getParent());
        }
        mLoader.addURL(theURL);
        mClasses = null;
    }

    public static void add(File ... theFiles) {
        for (File aFile : theFiles) {
            if (!aFile.exists() || !aFile.canRead()) continue;
            List<File> aJarList = Files2.listFiles(aFile, new JarFileFilter());
            for (File aJarFile : aJarList) {
                try {
                    mLoader.addURL(new URL[]{aJarFile.toURI().toURL()});
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        mClasses = null;
    }

    public static Collection<Class> classes() {
        if (mClasses == null) {
            HashSet<Class> aClassList = new HashSet<Class>();
            String aSystemPath = System.getProperty("java.class.path");
            if (aSystemPath != null) {
                ArrayList<File> aFileList = new ArrayList<File>();
                for (String aPath : aSystemPath.split(File.pathSeparator)) {
                    aFileList.add(new File(aPath));
                }
                for (File aFile : aFileList) {
                    if (!aFile.exists()) continue;
                    if (aFile.isDirectory()) {
                        aClassList.addAll(ClassPath.listClassesFromDir(aFile));
                        continue;
                    }
                    aClassList.addAll(ClassPath.listClassesFromJar(aFile));
                }
            }
            for (URL aURL : mLoader.getURLs()) {
                if (aURL.toString().endsWith(".jar")) {
                    if (!aURL.toString().startsWith("jar:")) {
                        try {
                            aURL = new URL("jar:" + aURL.toString() + "!/");
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                    }
                    aClassList.addAll(ClassPath.listClassesFromJar(aURL));
                    continue;
                }
                if (!aURL.toString().endsWith(".class")) continue;
            }
            mClasses = aClassList;
        }
        return mClasses;
    }

    public static Collection<? extends Class> listClassesFromDir(File theFile) {
        HashSet<? extends Class> aClassList = new HashSet<Class>();
        List<File> aJarList = Files2.listFiles(theFile, new JarFileFilter());
        for (File aJarFile : aJarList) {
            aClassList.addAll(ClassPath.listClassesFromJar(aJarFile));
        }
        List<File> aClassFileList = Files2.listFiles(theFile, new ClassFileFilter());
        for (File aClassFile : aClassFileList) {
            Class aClass = ClassPath._class(ClassPath.classNameFromFileName(aClassFile.getAbsolutePath().substring(theFile.getAbsolutePath().length() + 1)));
            if (aClass == null) continue;
            aClassList.add(aClass);
        }
        return aClassList;
    }

    private static Class _class(String theClassName) {
        if (theClassName == null) {
            return null;
        }
        if (theClassName.startsWith("java.") || theClassName.startsWith("javax.") || theClassName.startsWith("sun.") || theClassName.startsWith("com.sun.") || theClassName.startsWith("apple.") || theClassName.startsWith("com.apple") || theClassName.startsWith("org.jdesktop.")) {
            return null;
        }
        try {
            return ClassPath.get(theClassName);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Collection<? extends Class> listClassesFromJarFile(JarFile theFile) {
        HashSet<Class> aClassList = new HashSet<Class>();
        Enumeration<JarEntry> aEntries = theFile.entries();
        while (aEntries.hasMoreElements()) {
            Class aClass;
            JarEntry aEntry = aEntries.nextElement();
            if (!aEntry.getName().endsWith(".class") || (aClass = ClassPath._class(ClassPath.classNameFromFileName(aEntry.getName()))) == null) continue;
            aClassList.add(aClass);
        }
        return aClassList;
    }

    public static Collection<? extends Class> listClassesFromJar(URL theURL) {
        try {
            URLConnection aConn = theURL.openConnection();
            if (!(aConn instanceof JarURLConnection)) {
                return new HashSet();
            }
            JarURLConnection aJarConn = (JarURLConnection)aConn;
            return ClassPath.listClassesFromJarFile(aJarConn.getJarFile());
        }
        catch (IOException e) {
            return new HashSet();
        }
    }

    public static Class get(String theName) {
        try {
            return Class.forName(theName, true, mLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Collection<? extends Class> listClassesFromJar(File theFile) {
        try {
            if (theFile.canRead()) {
                return ClassPath.listClassesFromJarFile(new JarFile(theFile));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new HashSet();
    }

    private static String classNameFromFileName(String theName) {
        return theName.substring(0, theName.length() - ".class".length()).replaceAll("/|\\\\", "\\.");
    }

    static {
        mLoader = new MutableURLClassLoader(new URL[0], Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(mLoader);
    }

    public static class MutableURLClassLoader
    extends URLClassLoader {
        public MutableURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public void addURL(URL ... theURLs) {
            for (URL aURL : theURLs) {
                super.addURL(aURL);
            }
        }
    }

    private static class JarFileFilter
    implements FileFilter {
        private JarFileFilter() {
        }

        @Override
        public boolean accept(File thePathname) {
            return thePathname.getName().toLowerCase().endsWith(".jar");
        }
    }

    private static class ClassFileFilter
    implements FileFilter {
        private ClassFileFilter() {
        }

        @Override
        public boolean accept(File thePathname) {
            return thePathname.getName().toLowerCase().endsWith(".class");
        }
    }
}

