/*
 * Decompiled with CFR 0.152.
 */
package com.github.jqudt.uo;

import com.github.jqudt.Unit;
import com.github.jqudt.onto.UnitFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UnitOntologyFactory {
    private static UnitOntologyFactory factory = null;
    private Map<String, String> uo2qudt = new HashMap<String, String>(){
        {
            this.put(this.longURI("uo:EFO_0004374"), this.longURI("ops:MilligramPerDeciliter"));
            this.put(this.longURI("uo:EFO_0004385"), this.longURI("ops:PicogramPerMilliliter"));
            this.put(this.longURI("uo:UO_0000009"), this.longURI("qudt:Kilogram"));
            this.put(this.longURI("uo:UO_0000010"), this.longURI("qudt:SecondTime"));
            this.put(this.longURI("uo:UO_0000015"), this.longURI("qudt:Centimeter"));
            this.put(this.longURI("uo:UO_0000016"), this.longURI("qudt:Millimeter"));
            this.put(this.longURI("uo:UO_0000017"), this.longURI("qudt:Micrometer"));
            this.put(this.longURI("uo:UO_0000018"), this.longURI("ops:Nanometer"));
            this.put(this.longURI("uo:UO_0000021"), this.longURI("qudt:Gram"));
            this.put(this.longURI("uo:UO_0000022"), this.longURI("ops:Milligram"));
            this.put(this.longURI("uo:UO_0000023"), this.longURI("ops:Microgram"));
            this.put(this.longURI("uo:UO_0000024"), this.longURI("ops:Nanogram"));
            this.put(this.longURI("uo:UO_0000025"), this.longURI("ops:Picogram"));
            this.put(this.longURI("uo:UO_0000026"), this.longURI("ops:Femtogram"));
            this.put(this.longURI("uo:UO_0000027"), this.longURI("qudt:DegreeCelsius"));
            this.put(this.longURI("uo:UO_0000028"), this.longURI("qudt:Millisecond"));
            this.put(this.longURI("uo:UO_0000031"), this.longURI("qudt:MinuteTime"));
            this.put(this.longURI("uo:UO_0000032"), this.longURI("qudt:Hour"));
            this.put(this.longURI("uo:UO_0000033"), this.longURI("qudt:Day"));
            this.put(this.longURI("uo:UO_0000039"), this.longURI("qudt:Micromole"));
            this.put(this.longURI("uo:UO_0000040"), this.longURI("qudt:Millimole"));
            this.put(this.longURI("uo:UO_0000041"), this.longURI("qudt:Nanomole"));
            this.put(this.longURI("uo:UO_0000042"), this.longURI("qudt:Picomole"));
            this.put(this.longURI("uo:UO_0000043"), this.longURI("qudt:Femtomole"));
            this.put(this.longURI("uo:UO_0000062"), this.longURI("ops:Molar"));
            this.put(this.longURI("uo:UO_0000063"), this.longURI("ops:Millimolar"));
            this.put(this.longURI("uo:UO_0000064"), this.longURI("ops:Micromolar"));
            this.put(this.longURI("uo:UO_0000065"), this.longURI("ops:Nanomolar"));
            this.put(this.longURI("uo:UO_0000066"), this.longURI("ops:Picomolar"));
            this.put(this.longURI("uo:UO_0000073"), this.longURI("ops:Femtomolar"));
            this.put(this.longURI("uo:UO_0000098"), this.longURI("ops:Milliliter"));
            this.put(this.longURI("uo:UO_0000099"), this.longURI("qudt:Liter"));
            this.put(this.longURI("uo:UO_0000101"), this.longURI("ops:Microliter"));
            this.put(this.longURI("uo:UO_0000169"), this.longURI("ops:PartsPerMillion"));
            this.put(this.longURI("uo:UO_0000173"), this.longURI("ops:GramPerMilliliter"));
            this.put(this.longURI("uo:UO_0000175"), this.longURI("ops:GramPerLiter"));
            this.put(this.longURI("uo:UO_0000176"), this.longURI("ops:MilligramPerMilliliter"));
            this.put(this.longURI("uo:UO_0000187"), this.longURI("qudt:Percent"));
            this.put(this.longURI("uo:UO_0000197"), this.longURI("ops:LiterPerKilogram"));
            this.put(this.longURI("uo:UO_0000198"), this.longURI("ops:MilliliterPerKilogram"));
            this.put(this.longURI("uo:UO_0000271"), this.longURI("ops:MicroliterPerMinute"));
            this.put(this.longURI("uo:UO_0000272"), this.longURI("qudt:MillimeterOfMercury"));
            this.put(this.longURI("uo:UO_0000274"), this.longURI("ops:MicrogramPerMilliliter"));
            this.put(this.longURI("uo:UO_0000275"), this.longURI("ops:NanogramPerMilliliter"));
            this.put(this.longURI("uo:UO_0000308"), this.longURI("ops:MilligramPerKilogram"));
        }

        String longURI(String shortened) {
            if (shortened.startsWith("uo:")) {
                return "http://purl.obolibrary.org/obo/" + shortened.substring(3);
            }
            if (shortened.startsWith("ops:")) {
                return "http://www.openphacts.org/units/" + shortened.substring(4);
            }
            return null;
        }
    };
    private Map<String, String> qudt2uo = new HashMap<String, String>();

    private UnitOntologyFactory() {
        for (String keyURI : this.uo2qudt.keySet()) {
            this.qudt2uo.put(this.uo2qudt.get(keyURI), keyURI);
        }
    }

    public static UnitOntologyFactory getInstance() {
        if (factory == null) {
            factory = new UnitOntologyFactory();
        }
        return factory;
    }

    private static URI asURI(String resource) {
        try {
            return new URI(resource);
        }
        catch (URISyntaxException exception) {
            return null;
        }
    }

    public Unit getUnit(String resource) {
        System.out.println("resource:" + resource);
        return this.getUnit(UnitOntologyFactory.asURI(resource));
    }

    public Unit getUnit(URI resource) {
        if (resource == null) {
            throw new IllegalArgumentException("The URI cannot be null");
        }
        URI mappedURI = UnitOntologyFactory.asURI(this.uo2qudt.get(resource.toString()));
        if (mappedURI != null) {
            return UnitFactory.getInstance().getUnit(mappedURI);
        }
        return null;
    }

    public List<String> getURIs(String type) {
        URI uri;
        try {
            uri = new URI(type);
        }
        catch (URISyntaxException exception) {
            throw new IllegalStateException("Invalid URI: " + type, exception);
        }
        return this.getURIs(uri);
    }

    public List<String> getURIs(URI type) {
        ArrayList<String> uris = new ArrayList<String>();
        List<String> qudtURIs = UnitFactory.getInstance().getURIs(type);
        for (String qudtString : qudtURIs) {
            String uoURI = this.qudt2uo.get(qudtString);
            if (uoURI == null) continue;
            uris.add(uoURI);
        }
        return uris;
    }
}

