/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.units;

import com.github.jqudt.Unit;
import com.github.jqudt.onto.UnitFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitCollector {
    static Logger LOG = LoggerFactory.getLogger(UnitCollector.class);
    private static final String namespace = "http://qudt.org/schema/qudt#";
    private static final String[] unitTypeClasses = new String[]{"DerivedUnit", "unit", "DimensionlessUnit", "ScienceAndEngineeringUnit", "ResourceUnit", "BaseUnit", "SIBaseUnit", "DerivedUnit", "PhysicalUnit", "ComputingUnit", "CommunicationsUnit", "BiomedicalUnit", "RadiologyUnit", "NonSIUnit", "ChemistryUnit", "LogarithmicUnit", "SIUnit", "AtomicPhysicsUnit", "MechanicsUnit", "SpaceAndTimeUnit", "ElectricityAndMagnetismUnit", "ThermodynamicsUnit", "PerMeter", "SquareMeterKelvin", "PerCubicMeter", "CurvatureUnit", "LengthUnit", "VolumeUnit", "AngleUnit", "AreaAngleUnit", "TimeUnit", "AccelerationUnit", "TimeSquaredUnit", "FrequencyUnit", "VelocityUnit", "TimeAreaUnit", "AreaUnit", "VolumePerTimeUnit", "AreaTimeTemperatureUnit", "SpecificHeatVolumeUnit", "ThermalEnergyUnit", "TemperaturePerTimeUnit", "MolarHeatCapacityUnit", "LengthTemperatureTimeUnit", "ThermalEnergyLengthUnit", "ThermalResistivityUnit", "TemperatureUnit", "ThermalDiffusivityUnit", "ThermalConductivityUnit", "MassTemperatureUnit", "ThermalExpansionUnit", "CoefficientOfHeatTransferUnit", "SpecificHeatPressureUnit", "HeatFlowRateUnit", "ThermalResistanceUnit", "HeatCapacityAndEntropyUnit", "ThermalInsulanceUnit", "LengthTemperatureUnit", "AreaTemperatureUnit", "SpecificHeatCapacityUnit", "LinearVelocityUnit", "AngularVelocityUnit"};
    private Set<Unit> availableUnits = new HashSet<Unit>();
    private Set<Unit> availableUnitTypes = new HashSet<Unit>();

    public UnitCollector() {
        this.collect();
    }

    private void collect() {
        for (String newUri : unitTypeClasses) {
            try {
                Unit unitType = UnitFactory.getInstance().getUnit(namespace + newUri);
                if (unitType != null) {
                    this.availableUnitTypes.add(unitType);
                }
                List<String> uris = UnitFactory.getInstance().getURIs(namespace + newUri);
                for (String uri : uris) {
                    Unit unit = UnitFactory.getInstance().getUnit(uri);
                    if (unit == null) continue;
                    this.availableUnits.add(unit);
                }
            }
            catch (Exception e) {
                LOG.warn("No entry found");
            }
        }
    }

    public Set<Unit> getAvailableUnits() {
        return this.availableUnits;
    }

    public Set<Unit> getAvailableUnitTypes() {
        return this.availableUnitTypes;
    }
}

