/*
 * Decompiled with CFR 0.152.
 */
package com.github.jqudt;

import com.github.jqudt.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Quantity {
    static Logger LOG = LoggerFactory.getLogger(Quantity.class);
    private double value;
    private Unit unit;

    private Quantity() {
    }

    public Quantity(double value, Unit unit) {
        this.value = value;
        this.unit = unit;
    }

    public double getValue() {
        return this.value;
    }

    private void setValue(double value) {
        this.value = value;
    }

    public Unit getUnit() {
        return this.unit;
    }

    private void setUnit(Unit unit) {
        this.unit = unit;
    }

    public Quantity convertTo(Unit newUnit) throws IllegalArgumentException, IllegalAccessException {
        if (newUnit == null) {
            LOG.error("Target unit cannot be null");
            throw new IllegalArgumentException("Target unit cannot be null");
        }
        if (this.unit == null) {
            LOG.error("This measurement does not have units defined");
            throw new IllegalAccessException("This measurement does not have units defined");
        }
        if (this.unit.getResource().equals(newUnit.getResource())) {
            return this;
        }
        if (!this.unit.getType().equals(newUnit.getType())) {
            LOG.error("The new unit does not have the same parent type (source: " + this.unit.getType() + "; target: " + newUnit.getType() + ")");
            throw new IllegalAccessException("The new unit does not have the same parent type (source: " + this.unit.getType() + "; target: " + newUnit.getType() + ")");
        }
        Quantity newMeasurement = new Quantity();
        newMeasurement.setUnit(newUnit);
        newMeasurement.setValue((this.value * this.unit.getMultiplier().getMultiplier() + this.unit.getMultiplier().getOffset() - newUnit.getMultiplier().getOffset()) / newUnit.getMultiplier().getMultiplier());
        return newMeasurement;
    }

    public String toString() {
        return "" + this.getValue() + " " + this.getUnit().toString();
    }
}

