/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.units;

import com.github.jqudt.Unit;
import com.github.jqudt.onto.UnitFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streampipes.units.UnitCollector;

public enum UnitProvider {
    INSTANCE;

    static Logger LOG;
    private List<Unit> availableUnitTypes = new ArrayList<Unit>();
    private List<Unit> availableUnits = new ArrayList<Unit>();
    private UnitFactory factory = UnitFactory.getInstance();

    private UnitProvider() {
        UnitCollector collector = new UnitCollector();
        this.availableUnits.addAll(collector.getAvailableUnits());
        this.availableUnitTypes.addAll(collector.getAvailableUnitTypes());
    }

    public List<Unit> getAvailableUnitTypes() {
        return this.availableUnitTypes;
    }

    public List<Unit> getAvailableUnits() {
        return this.availableUnits;
    }

    public Unit getUnit(String resourceUri) {
        return this.factory.getUnit(resourceUri);
    }

    public Unit getUnitByLabel(String label) {
        try {
            return this.availableUnits.stream().filter(unit -> unit.getLabel().equals(label)).findFirst().get();
        }
        catch (NoSuchElementException e) {
            LOG.error("No unit with label \"" + label + "\" found");
            return null;
        }
    }

    public List<Unit> getUnitsByType(URI type) {
        return this.availableUnits.stream().filter(u -> u.getType().equals(type)).collect(Collectors.toList());
    }

    static {
        LOG = LoggerFactory.getLogger(UnitCollector.class);
    }
}

