/*
 * Decompiled with CFR 0.152.
 */
package com.github.jqudt.onto;

import com.github.jqudt.Multiplier;
import com.github.jqudt.Unit;
import com.github.jqudt.onto.OntoReader;
import com.github.jqudt.onto.QUDT;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.ValueFactoryImpl;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;

public class UnitFactory {
    private Model repos = new LinkedHashModel();
    private static UnitFactory factory = null;

    private UnitFactory() {
        try {
            OntoReader.read(this.repos, "unit");
            OntoReader.read(this.repos, "qudt");
            OntoReader.read(this.repos, "quantity");
            OntoReader.read(this.repos, "ops.ttl");
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not load the QUDT ontologies: " + exception.getMessage(), exception);
        }
    }

    public static UnitFactory getInstance() {
        if (factory == null) {
            factory = new UnitFactory();
        }
        return factory;
    }

    public Unit getUnit(String resource) {
        java.net.URI uri;
        try {
            uri = new java.net.URI(resource);
        }
        catch (URISyntaxException exception) {
            throw new IllegalStateException("Invalid URI: " + resource, exception);
        }
        return this.getUnit(uri);
    }

    public Unit getUnit(java.net.URI resource) {
        if (resource == null) {
            throw new IllegalArgumentException("The URI cannot be null");
        }
        ValueFactoryImpl f = ValueFactoryImpl.getInstance();
        URI uri = f.createURI(resource.toString());
        Unit unit = new Unit();
        unit.setResource(resource);
        Multiplier multiplier = new Multiplier();
        try {
            Model statements = this.repos.filter((Resource)uri, null, null, new Resource[0]);
            if (statements.isEmpty()) {
                throw new IllegalStateException("No ontology entry found for: " + resource.toString());
            }
            for (Statement statement : statements) {
                URI typeURI;
                Value type;
                if (statement.getPredicate().equals((Object)QUDT.SYMBOL)) {
                    unit.setSymbol(statement.getObject().stringValue());
                    continue;
                }
                if (statement.getPredicate().equals((Object)QUDT.ABBREVIATION)) {
                    unit.setAbbreviation(statement.getObject().stringValue());
                    continue;
                }
                if (statement.getPredicate().equals((Object)QUDT.CONVERSION_OFFSET)) {
                    multiplier.setOffset(Double.parseDouble(statement.getObject().stringValue()));
                    continue;
                }
                if (statement.getPredicate().equals((Object)QUDT.CONVERSION_MULTIPLIER)) {
                    multiplier.setMultiplier(Double.parseDouble(statement.getObject().stringValue()));
                    continue;
                }
                if (statement.getPredicate().equals((Object)RDFS.LABEL)) {
                    unit.setLabel(statement.getObject().stringValue());
                    continue;
                }
                if (!statement.getPredicate().equals((Object)RDF.TYPE) || !((type = statement.getObject()) instanceof URI) || this.shouldBeIgnored(typeURI = (URI)type)) continue;
                unit.setType(new java.net.URI(typeURI.stringValue()));
            }
            unit.setMultiplier(multiplier);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not create the unit: " + exception.getMessage(), exception);
        }
        return unit;
    }

    public List<Unit> findUnits(String symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException("The symbol cannot be null");
        }
        ValueFactoryImpl f = ValueFactoryImpl.getInstance();
        Model statements = this.repos.filter(null, QUDT.ABBREVIATION, (Value)f.createLiteral(symbol, XMLSchema.STRING), new Resource[0]);
        if (statements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Unit> foundUnits = new ArrayList<Unit>();
        for (Statement statement : statements) {
            Resource type = statement.getSubject();
            try {
                if (!(type instanceof URI)) continue;
                URI typeURI = (URI)type;
                foundUnits.add(this.getUnit(typeURI.toString()));
            }
            catch (Exception exception) {}
        }
        return foundUnits;
    }

    public List<String> getURIs(String type) {
        java.net.URI uri;
        try {
            uri = new java.net.URI(type);
        }
        catch (URISyntaxException exception) {
            throw new IllegalStateException("Invalid URI: " + type, exception);
        }
        return this.getURIs(uri);
    }

    public List<String> getURIs(java.net.URI type) {
        if (type == null) {
            throw new IllegalArgumentException("The type cannot be null");
        }
        ValueFactoryImpl f = ValueFactoryImpl.getInstance();
        URI uri = f.createURI(type.toString());
        try {
            Model statements = this.repos.filter(null, null, (Value)uri, new Resource[0]);
            if (statements.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> units = new ArrayList<String>();
            for (Statement statement : statements) {
                units.add(statement.getSubject().toString());
            }
            return units;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error while getting the units: " + exception.getMessage(), exception);
        }
    }

    private boolean shouldBeIgnored(URI typeURI) {
        if (!typeURI.getNamespace().equals("http://qudt.org/schema/qudt#")) {
            return false;
        }
        if (typeURI.equals((Object)QUDT.SI_DERIVED_UNIT)) {
            return true;
        }
        if (typeURI.equals((Object)QUDT.SI_BASE_UNIT)) {
            return true;
        }
        if (typeURI.equals((Object)QUDT.SI_UNIT)) {
            return true;
        }
        if (typeURI.equals((Object)QUDT.DERIVED_UNIT)) {
            return true;
        }
        if (typeURI.equals((Object)QUDT.NOT_USED_WITH_SI_UNIT)) {
            return true;
        }
        return typeURI.equals((Object)QUDT.USED_WITH_SI_UNIT);
    }
}

