/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.messaging;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.streampipes.messaging.SpProtocolDefinition;
import org.streampipes.messaging.SpProtocolDefinitionFactory;
import org.streampipes.model.grounding.TransportProtocol;

public enum SpProtocolManager {
    INSTANCE;

    private List<SpProtocolDefinitionFactory<? extends TransportProtocol>> availableProtocols = new ArrayList<SpProtocolDefinitionFactory<? extends TransportProtocol>>();

    public void register(SpProtocolDefinitionFactory<? extends TransportProtocol> protocolDefinition) {
        this.availableProtocols.add(protocolDefinition);
    }

    public List<SpProtocolDefinitionFactory<? extends TransportProtocol>> getAvailableProtocols() {
        return this.availableProtocols;
    }

    public <T extends TransportProtocol> Optional<SpProtocolDefinition<T>> findDefinition(T transportProtocol) {
        return this.availableProtocols.stream().filter(adf -> adf.getTransportProtocolClass().equals(transportProtocol.getClass().getCanonicalName())).map(s -> s).map(SpProtocolDefinitionFactory::createInstance).findFirst();
    }
}

