/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.client.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.streampipes.model.client.messages.Notification;

public abstract class Message {
    private boolean success;
    private String elementName;
    private List<Notification> notifications;

    public Message(boolean success) {
        this.success = success;
        this.notifications = null;
    }

    public Message(boolean success, List<Notification> notifications) {
        this.success = success;
        this.notifications = notifications;
    }

    public Message(boolean success, List<Notification> notifications, String elementName) {
        this(success, notifications);
        this.elementName = elementName;
    }

    public Message(boolean success, Notification ... notifications) {
        this.success = success;
        this.notifications = new ArrayList<Notification>();
        this.notifications.addAll(Arrays.asList(notifications));
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public List<Notification> getNotifications() {
        return this.notifications;
    }

    public void setNotifications(List<Notification> notifications) {
        this.notifications = notifications;
    }

    public boolean addNotification(Notification notification) {
        return this.notifications.add(notification);
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }
}

