/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.client.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.apache.commons.lang.RandomStringUtils;
import org.streampipes.empire.annotations.Namespaces;
import org.streampipes.empire.annotations.RdfId;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.client.messages.NotificationLd;

@Namespaces(value={"sp", "https://streampipes.org/vocabulary/v1/"})
@RdfsClass(value="https://streampipes.org/vocabulary/v1/Message")
@Entity
public class MessageLd {
    private static final String prefix = "urn:streampipes.org:spi:";
    @RdfId
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasElementName")
    private String elementId = "urn:streampipes.org:spi:" + this.getClass().getSimpleName().toLowerCase() + ":" + RandomStringUtils.randomAlphabetic((int)6);
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/messsageSuccess")
    private boolean success;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/messageElementName")
    private String elementName = "";
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/notifications")
    private List<NotificationLd> notifications;

    public MessageLd() {
    }

    public MessageLd(MessageLd other) {
        this();
        this.success = other.isSuccess();
        this.elementName = other.getElementName();
        this.notifications = other.getNotifications();
    }

    public MessageLd(boolean success) {
        this();
        this.success = success;
        this.notifications = null;
    }

    public MessageLd(boolean success, List<NotificationLd> notifications) {
        this();
        this.success = success;
        this.notifications = notifications;
    }

    public MessageLd(boolean success, List<NotificationLd> notifications, String elementName) {
        this(success, notifications);
        this.elementName = elementName;
    }

    public MessageLd(boolean success, NotificationLd ... notifications) {
        this();
        this.success = success;
        this.notifications = new ArrayList<NotificationLd>();
        this.notifications.addAll(Arrays.asList(notifications));
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public List<NotificationLd> getNotifications() {
        return this.notifications;
    }

    public void setNotifications(List<NotificationLd> notifications) {
        this.notifications = notifications;
    }

    public boolean addNotification(NotificationLd notification) {
        return this.notifications.add(notification);
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public String getElementId() {
        return this.elementId;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }
}

