/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.client.messages;

import org.streampipes.model.client.messages.ErrorMessage;
import org.streampipes.model.client.messages.ErrorMessageLd;
import org.streampipes.model.client.messages.Notification;
import org.streampipes.model.client.messages.NotificationLd;
import org.streampipes.model.client.messages.NotificationType;
import org.streampipes.model.client.messages.SuccessMessage;
import org.streampipes.model.client.messages.SuccessMessageLd;

public class Notifications {
    public static Notification create(NotificationType type) {
        return new Notification(type.name(), type.description());
    }

    public static Notification create(NotificationType type, String info) {
        return new Notification(type.name(), type.description(), info);
    }

    public static SuccessMessage success(NotificationType type) {
        return new SuccessMessage(new Notification(type.name(), type.description()));
    }

    public static SuccessMessage success(NotificationType type, String info) {
        return new SuccessMessage(new Notification(type.name(), type.description(), info));
    }

    public static SuccessMessage success(String message) {
        return new SuccessMessage(new Notification(message, ""));
    }

    public static ErrorMessage error(NotificationType type) {
        return new ErrorMessage(new Notification(type.name(), type.description()));
    }

    public static ErrorMessage error(String message) {
        return new ErrorMessage(new Notification(message, ""));
    }

    public static ErrorMessage error(NotificationType type, String info) {
        return new ErrorMessage(new Notification(type.name(), type.description(), info));
    }

    public static NotificationLd createLd(NotificationType type, String info) {
        return new NotificationLd(type.name(), type.description(), info);
    }

    public static SuccessMessageLd successLd(NotificationType type) {
        return new SuccessMessageLd(new NotificationLd(type.name(), type.description()));
    }

    public static SuccessMessageLd successLd(NotificationType type, String info) {
        return new SuccessMessageLd(new NotificationLd(type.name(), type.description(), info));
    }

    public static SuccessMessageLd successLd(String message) {
        return new SuccessMessageLd(new NotificationLd(message, ""));
    }

    public static ErrorMessageLd errorLd(NotificationType type) {
        return new ErrorMessageLd(new NotificationLd(type.name(), type.description()));
    }

    public static ErrorMessageLd errorLd(String message) {
        return new ErrorMessageLd(new NotificationLd(message, ""));
    }

    public static ErrorMessageLd errorLd(NotificationType type, String info) {
        return new ErrorMessageLd(new NotificationLd(type.name(), type.description(), info));
    }
}

