/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model;

import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToOne;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.grounding.EventGrounding;
import org.streampipes.model.quality.EventStreamQualityDefinition;
import org.streampipes.model.schema.EventSchema;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/DataSet")
@Entity
public class SpDataSet
extends SpDataStream {
    private static final String prefix = "urn:fzi.de:dataset:";
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/supportedGrounding")
    private EventGrounding supportedGrounding;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/DataSetInvocationId")
    private String datasetInvocationId;

    public SpDataSet(String uri, String name, String description, String iconUrl, List<EventStreamQualityDefinition> hasEventStreamQualities, EventGrounding eventGrounding, EventSchema eventSchema) {
        super(uri, name, description, iconUrl, hasEventStreamQualities, eventGrounding, eventSchema);
    }

    public SpDataSet(String uri, String name, String description, EventSchema eventSchema) {
        super(uri, name, description, eventSchema);
    }

    public SpDataSet() {
    }

    public SpDataSet(SpDataSet other) {
        super(other);
        this.datasetInvocationId = other.getDatasetInvocationId();
        if (other.getSupportedGrounding() != null) {
            this.supportedGrounding = new EventGrounding(other.getSupportedGrounding());
        }
    }

    public EventGrounding getSupportedGrounding() {
        return this.supportedGrounding;
    }

    public void setSupportedGrounding(EventGrounding supportedGrounding) {
        this.supportedGrounding = supportedGrounding;
    }

    public String getDatasetInvocationId() {
        return this.datasetInvocationId;
    }

    public void setDatasetInvocationId(String datasetInvocationId) {
        this.datasetInvocationId = datasetInvocationId;
    }
}

