/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.base;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.RdfId;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.model.ApplicationLink;
import org.streampipes.model.base.AbstractStreamPipesEntity;
import org.streampipes.model.util.Cloner;

public abstract class NamedStreamPipesEntity
extends AbstractStreamPipesEntity {
    private static final long serialVersionUID = -98951691820519795L;
    @RdfProperty(value="http://www.w3.org/2000/01/rdf-schema#label")
    private String name;
    @RdfProperty(value="http://www.w3.org/2000/01/rdf-schema#description")
    private String description;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/iconUrl")
    private String iconUrl;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasUri")
    @RdfId
    private String uri;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasApplicationLink")
    private List<ApplicationLink> applicationLinks;
    protected String elementId;
    protected String DOM;
    protected List<String> connectedTo;

    public NamedStreamPipesEntity() {
        this.applicationLinks = new ArrayList<ApplicationLink>();
    }

    public NamedStreamPipesEntity(String uri) {
        this.uri = uri;
        this.applicationLinks = new ArrayList<ApplicationLink>();
    }

    public NamedStreamPipesEntity(String uri, String name, String description, String iconUrl) {
        this(uri, name, description);
        this.iconUrl = iconUrl;
        this.applicationLinks = new ArrayList<ApplicationLink>();
    }

    public NamedStreamPipesEntity(String uri, String name, String description) {
        this.uri = uri;
        this.name = name;
        this.description = description;
        this.elementId = uri;
        this.applicationLinks = new ArrayList<ApplicationLink>();
    }

    public NamedStreamPipesEntity(NamedStreamPipesEntity other) {
        this.description = other.getDescription();
        this.name = other.getName();
        this.iconUrl = other.getIconUrl();
        this.uri = other.getUri();
        this.DOM = other.getDOM();
        this.connectedTo = other.getConnectedTo();
        this.elementId = other.getElementId();
        if (other.getApplicationLinks() != null) {
            this.applicationLinks = new Cloner().al(other.getApplicationLinks());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getElementId() {
        return this.uri;
    }

    public void setElementId(String elementId) {
        this.uri = elementId;
    }

    public void setDOM(String DOM) {
        this.DOM = DOM;
    }

    public String getDOM() {
        return this.DOM;
    }

    public List<String> getConnectedTo() {
        return this.connectedTo;
    }

    public void setConnectedTo(List<String> connectedTo) {
        this.connectedTo = connectedTo;
    }

    public List<ApplicationLink> getApplicationLinks() {
        return this.applicationLinks;
    }

    public void setApplicationLinks(List<ApplicationLink> applicationLinks) {
        this.applicationLinks = applicationLinks;
    }
}

