/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.graph;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.ConsumableStreamPipesEntity;
import org.streampipes.model.output.OutputStrategy;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/DataProcessorDescription")
@Entity
public class DataProcessorDescription
extends ConsumableStreamPipesEntity {
    private static final long serialVersionUID = 3995767921861518597L;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasOutputStrategy")
    private List<OutputStrategy> outputStrategies;
    private String pathName;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasEpaType")
    private List<String> category;

    public DataProcessorDescription(DataProcessorDescription other) {
        super(other);
        this.outputStrategies = new Cloner().strategies(other.getOutputStrategies());
        this.pathName = other.getPathName();
        this.category = new Cloner().epaTypes(other.getCategory());
    }

    public DataProcessorDescription() {
        this.outputStrategies = new ArrayList<OutputStrategy>();
        this.category = new ArrayList<String>();
    }

    public DataProcessorDescription(String uri, String name, String description, String iconUrl, List<SpDataStream> spDataStreams, List<StaticProperty> staticProperties, List<OutputStrategy> outputStrategies) {
        super(uri, name, description, iconUrl);
        this.pathName = uri;
        this.spDataStreams = spDataStreams;
        this.staticProperties = staticProperties;
        this.outputStrategies = outputStrategies;
    }

    public DataProcessorDescription(String pathName, String name, String description, String iconUrl) {
        super(pathName, name, description, iconUrl);
        this.pathName = pathName;
        this.spDataStreams = new ArrayList();
        this.staticProperties = new ArrayList();
    }

    public DataProcessorDescription(String pathName, String name, String description) {
        super(pathName, name, description, "");
        this.pathName = pathName;
        this.spDataStreams = new ArrayList();
        this.staticProperties = new ArrayList();
    }

    public List<String> getCategory() {
        return this.category;
    }

    public void setCategory(List<String> category) {
        this.category = category;
    }

    public String getPathName() {
        return this.pathName;
    }

    public void setPathName(String pathName) {
        this.pathName = pathName;
    }

    public List<OutputStrategy> getOutputStrategies() {
        return this.outputStrategies;
    }

    public void setOutputStrategies(List<OutputStrategy> outputStrategies) {
        this.outputStrategies = outputStrategies;
    }
}

