/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.graph.DataProcessorDescription;
import org.streampipes.model.output.OutputStrategy;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/DataProcessorInvocation")
@Entity
public class DataProcessorInvocation
extends InvocableStreamPipesEntity
implements Serializable {
    private static final long serialVersionUID = 865870355944824186L;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/produces")
    private SpDataStream outputStream;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasOutputStrategy")
    private List<OutputStrategy> outputStrategies;
    private String pathName;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasEpaType")
    private List<String> category;

    public DataProcessorInvocation(DataProcessorDescription sepa) {
        this.setName(sepa.getName());
        this.setDescription(sepa.getDescription());
        this.setIconUrl(sepa.getIconUrl());
        this.setInputStreams(sepa.getSpDataStreams());
        this.setSupportedGrounding(sepa.getSupportedGrounding());
        this.setStaticProperties(sepa.getStaticProperties());
        this.setOutputStrategies(sepa.getOutputStrategies());
        this.setBelongsTo(sepa.getElementId().toString());
        this.category = sepa.getCategory();
        this.setStreamRequirements(sepa.getSpDataStreams());
    }

    public DataProcessorInvocation(DataProcessorInvocation other) {
        super(other);
        this.outputStrategies = new Cloner().strategies(other.getOutputStrategies());
        if (other.getOutputStream() != null) {
            this.outputStream = new Cloner().stream(other.getOutputStream());
        }
        this.pathName = other.getPathName();
        this.category = new Cloner().epaTypes(other.getCategory());
    }

    public DataProcessorInvocation(DataProcessorDescription sepa, String domId) {
        this(sepa);
        this.DOM = domId;
    }

    public DataProcessorInvocation() {
        this.inputStreams = new ArrayList();
    }

    public DataProcessorInvocation(String uri, String name, String description, String iconUrl, String pathName, List<SpDataStream> spDataStreams, List<StaticProperty> staticProperties) {
        super(uri, name, description, iconUrl);
        this.pathName = pathName;
        this.inputStreams = spDataStreams;
        this.staticProperties = staticProperties;
    }

    public DataProcessorInvocation(String uri, String name, String description, String iconUrl, String pathName) {
        super(uri, name, description, iconUrl);
        this.pathName = pathName;
        this.inputStreams = new ArrayList();
        this.staticProperties = new ArrayList();
    }

    public boolean addInputStream(SpDataStream spDataStream) {
        return this.inputStreams.add(spDataStream);
    }

    public String getPathName() {
        return this.pathName;
    }

    public void setPathName(String pathName) {
        this.pathName = pathName;
    }

    public SpDataStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(SpDataStream outputStream) {
        this.outputStream = outputStream;
    }

    public List<OutputStrategy> getOutputStrategies() {
        return this.outputStrategies;
    }

    public void setOutputStrategies(List<OutputStrategy> outputStrategies) {
        this.outputStrategies = outputStrategies;
    }

    public List<String> getCategory() {
        return this.category;
    }

    public void setCategory(List<String> category) {
        this.category = category;
    }
}

