/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.graph;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.graph.DataSinkDescription;
import org.streampipes.model.staticproperty.StaticProperty;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/DataSinkInvocation")
@Entity
public class DataSinkInvocation
extends InvocableStreamPipesEntity {
    private static final long serialVersionUID = -2345635798917416757L;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasEcType")
    private List<String> category;

    public DataSinkInvocation(DataSinkInvocation sec) {
        super(sec);
        this.category = sec.getCategory();
    }

    public DataSinkInvocation(DataSinkDescription sec) {
        this.setName(sec.getName());
        this.setDescription(sec.getDescription());
        this.setIconUrl(sec.getIconUrl());
        this.setInputStreams(sec.getSpDataStreams());
        this.setSupportedGrounding(sec.getSupportedGrounding());
        this.setStaticProperties(sec.getStaticProperties());
        this.setBelongsTo(sec.getElementId().toString());
        this.category = sec.getCategory();
        this.setStreamRequirements(sec.getSpDataStreams());
    }

    public DataSinkInvocation(DataSinkDescription sec, String domId) {
        this(sec);
        this.setDOM(domId);
    }

    public DataSinkInvocation() {
        this.inputStreams = new ArrayList();
    }

    @Override
    public List<StaticProperty> getStaticProperties() {
        return this.staticProperties;
    }

    @Override
    public void setStaticProperties(List<StaticProperty> staticProperties) {
        this.staticProperties = staticProperties;
    }

    public List<String> getCategory() {
        return this.category;
    }

    public void setCategory(List<String> category) {
        this.category = category;
    }
}

