/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.schema;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToOne;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/EventPropertyList")
@Entity
public class EventPropertyList
extends EventProperty {
    private static final long serialVersionUID = -2636018143426727534L;
    @Deprecated
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasEventProperty")
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<EventProperty> eventProperties;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasEventProperty")
    private EventProperty eventProperty;

    public EventPropertyList() {
        this.eventProperties = new ArrayList<EventProperty>();
    }

    public EventPropertyList(EventPropertyList other) {
        super(other);
        this.eventProperty = this.eventProperty;
        this.eventProperties = new Cloner().properties(other.getEventProperties());
    }

    public EventPropertyList(String propertyName, EventProperty eventProperty) {
        super(propertyName);
        this.eventProperty = eventProperty;
        this.eventProperties = new ArrayList<EventProperty>();
        this.eventProperties.add(eventProperty);
    }

    public EventPropertyList(String propertyName, EventProperty eventProperty, List<URI> domainProperties) {
        super(propertyName);
        this.eventProperty = eventProperty;
        this.setDomainProperties(domainProperties);
    }

    public EventProperty getEventProperty() {
        return this.eventProperty;
    }

    public void setEventProperty(EventProperty eventProperty) {
        this.eventProperty = eventProperty;
    }

    @Deprecated
    public List<EventProperty> getEventProperties() {
        return this.eventProperties;
    }

    @Deprecated
    public void setEventProperties(List<EventProperty> eventProperties) {
        this.eventProperties = eventProperties;
    }
}

