/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.staticproperty;

import java.net.URI;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.staticproperty.StaticPropertyType;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/MappingProperty")
@MappedSuperclass
@Entity
public abstract class MappingProperty
extends StaticProperty {
    private static final long serialVersionUID = -7849999126274124847L;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/mapsFrom")
    protected URI mapsFrom;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasMapsFromOptions")
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private List<EventProperty> mapsFromOptions;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasPropertyScope")
    private String propertyScope;

    public MappingProperty() {
    }

    public MappingProperty(StaticPropertyType type) {
        super(type);
    }

    public MappingProperty(MappingProperty other) {
        super(other);
        this.mapsFrom = other.getMapsFrom();
        this.propertyScope = other.getPropertyScope();
        if (other.getMapsFromOptions() != null) {
            this.mapsFromOptions = new Cloner().properties(other.getMapsFromOptions());
        }
    }

    protected MappingProperty(StaticPropertyType type, URI mapsFrom, String internalName, String label, String description) {
        super(type, internalName, label, description);
        this.mapsFrom = mapsFrom;
    }

    protected MappingProperty(StaticPropertyType type, String internalName, String label, String description) {
        super(type, internalName, label, description);
    }

    public URI getMapsFrom() {
        return this.mapsFrom;
    }

    public void setMapsFrom(URI mapsFrom) {
        this.mapsFrom = mapsFrom;
    }

    public List<EventProperty> getMapsFromOptions() {
        return this.mapsFromOptions;
    }

    public void setMapsFromOptions(List<EventProperty> mapsFromOptions) {
        this.mapsFromOptions = mapsFromOptions;
    }

    public String getPropertyScope() {
        return this.propertyScope;
    }

    public void setPropertyScope(String propertyScope) {
        this.propertyScope = propertyScope;
    }
}

