/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.graph.DataProcessorInvocation;
import org.streampipes.model.graph.DataSinkInvocation;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.EventPropertyList;
import org.streampipes.model.schema.EventPropertyNested;
import org.streampipes.model.schema.EventPropertyPrimitive;
import org.streampipes.model.staticproperty.DomainStaticProperty;
import org.streampipes.model.staticproperty.FreeTextStaticProperty;
import org.streampipes.model.staticproperty.MappingPropertyNary;
import org.streampipes.model.staticproperty.MappingPropertyUnary;
import org.streampipes.model.staticproperty.MatchingStaticProperty;
import org.streampipes.model.staticproperty.OneOfStaticProperty;
import org.streampipes.model.staticproperty.Option;
import org.streampipes.model.staticproperty.RemoteOneOfStaticProperty;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.staticproperty.SupportedProperty;

@Deprecated
public class SepaUtils {
    public static String getSupportedPropertyValue(DomainStaticProperty dsp, String propertyId) {
        Optional<SupportedProperty> matchedProperty = dsp.getSupportedProperties().stream().filter(sp -> sp.getPropertyId().equals(propertyId)).findFirst();
        if (matchedProperty.isPresent()) {
            return matchedProperty.get().getValue();
        }
        return "";
    }

    public static DomainStaticProperty getDomainStaticPropertyBy(InvocableStreamPipesEntity sepa, String internalName) {
        Optional<StaticProperty> matchedProperty = sepa.getStaticProperties().stream().filter(sp -> sp instanceof DomainStaticProperty && sp.getInternalName().equals(internalName)).findFirst();
        if (matchedProperty.isPresent()) {
            return (DomainStaticProperty)matchedProperty.get();
        }
        return null;
    }

    public static String getFreeTextStaticPropertyValue(InvocableStreamPipesEntity graph, String internalName) {
        StaticProperty staticProperty = SepaUtils.getStaticPropertyByInternalName(graph, internalName);
        if (staticProperty instanceof FreeTextStaticProperty) {
            return ((FreeTextStaticProperty)staticProperty).getValue();
        }
        return null;
    }

    public static StaticProperty getStaticPropertyByInternalName(InvocableStreamPipesEntity seg, String internalName) {
        return SepaUtils.getStaticPropertyByName(seg.getStaticProperties(), internalName);
    }

    public static <T> T getStaticPropertyByInternalName(InvocableStreamPipesEntity seg, String internalName, Class<T> clazz) {
        return clazz.cast(SepaUtils.getStaticPropertyByInternalName(seg, internalName));
    }

    public static StaticProperty getStaticPropertyByInternalName(DataSinkInvocation sec, String internalName) {
        return SepaUtils.getStaticPropertyByName(sec.getStaticProperties(), internalName);
    }

    public static String getMappingPropertyName(InvocableStreamPipesEntity sepa, String staticPropertyName) {
        return SepaUtils.getMappingPropertyName(sepa, staticPropertyName, false);
    }

    public static String getMappingPropertyName(InvocableStreamPipesEntity sepa, String staticPropertyName, boolean completeNames) {
        URI propertyURI = SepaUtils.getURIFromStaticProperty(sepa, staticPropertyName);
        for (SpDataStream stream : sepa.getInputStreams()) {
            List<String> matchedProperties = SepaUtils.getMappingPropertyName(stream.getEventSchema().getEventProperties(), propertyURI, completeNames, "");
            if (matchedProperties.size() <= 0) continue;
            return matchedProperties.get(0);
        }
        return null;
    }

    public static List<String> getMultipleMappingPropertyNames(InvocableStreamPipesEntity sepa, String staticPropertyName, boolean completeNames) {
        List<URI> propertyUris = SepaUtils.getMultipleURIsFromStaticProperty(sepa, staticPropertyName);
        ArrayList<String> result = new ArrayList<String>();
        for (URI propertyUri : propertyUris) {
            for (SpDataStream stream : sepa.getInputStreams()) {
                result.addAll(SepaUtils.getMappingPropertyName(stream.getEventSchema().getEventProperties(), propertyUri, completeNames, ""));
            }
        }
        return result;
    }

    private static List<String> getMappingPropertyName(List<EventProperty> eventProperties, URI propertyURI, boolean completeNames, String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        for (EventProperty p : eventProperties) {
            if (p instanceof EventPropertyPrimitive || p instanceof EventPropertyList) {
                if (p.getElementId().equals(propertyURI.toString())) {
                    if (!completeNames) {
                        result.add(p.getRuntimeName());
                    } else {
                        result.add(prefix + p.getRuntimeName());
                    }
                }
                if (!(p instanceof EventPropertyList)) continue;
                for (EventProperty sp : ((EventPropertyList)p).getEventProperties()) {
                    if (!sp.getElementId().toString().equals(propertyURI.toString())) continue;
                    result.add(p.getRuntimeName() + "," + sp.getRuntimeName());
                }
                continue;
            }
            if (!(p instanceof EventPropertyNested)) continue;
            result.addAll(SepaUtils.getMappingPropertyName(((EventPropertyNested)p).getEventProperties(), propertyURI, completeNames, prefix + p.getRuntimeName() + "."));
        }
        return result;
    }

    private static String getEventPropertyNameByPrefix(List<EventProperty> eventProperties, String namePrefix, boolean completeNames, String propertyPrefix) {
        for (EventProperty p : eventProperties) {
            if (p instanceof EventPropertyPrimitive || p instanceof EventPropertyList) {
                if (!p.getRuntimeName().startsWith(namePrefix)) continue;
                if (!completeNames) {
                    return p.getRuntimeName();
                }
                return propertyPrefix + p.getRuntimeName();
            }
            if (!(p instanceof EventPropertyNested) || !p.getRuntimeName().startsWith(namePrefix)) continue;
            if (!completeNames) {
                return p.getRuntimeName();
            }
            return propertyPrefix + p.getRuntimeName();
        }
        return null;
    }

    public static String getEventPropertyName(List<EventProperty> properties, String namePrefix) {
        return SepaUtils.getEventPropertyNameByPrefix(properties, namePrefix, true, "");
    }

    private static URI getMatchingPropertyURI(InvocableStreamPipesEntity sepa, String propertyName, boolean first) {
        List properties = sepa.getStaticProperties().stream().filter(sp -> sp instanceof MatchingStaticProperty).map(m -> (MatchingStaticProperty)m).collect(Collectors.toList());
        for (MatchingStaticProperty m2 : properties) {
            if (!m2.getInternalName().equals(propertyName)) continue;
            if (first) {
                return m2.getMatchLeft();
            }
            return m2.getMatchRight();
        }
        return null;
    }

    private static URI getURIFromStaticProperty(InvocableStreamPipesEntity sepa, String staticPropertyName) {
        for (StaticProperty p : sepa.getStaticProperties()) {
            MappingPropertyUnary mp;
            if (!(p instanceof MappingPropertyUnary) || !(mp = (MappingPropertyUnary)p).getInternalName().equals(staticPropertyName)) continue;
            return mp.getMapsTo();
        }
        return null;
    }

    private static List<URI> getMultipleURIsFromStaticProperty(InvocableStreamPipesEntity sepa, String staticPropertyName) {
        for (StaticProperty p : sepa.getStaticProperties()) {
            MappingPropertyNary mp;
            if (!(p instanceof MappingPropertyNary) || !(mp = (MappingPropertyNary)p).getInternalName().equals(staticPropertyName)) continue;
            return mp.getMapsTo();
        }
        return null;
    }

    private static StaticProperty getStaticPropertyByName(List<StaticProperty> properties, String name) {
        for (StaticProperty p : properties) {
            if (!p.getInternalName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public static String getOneOfProperty(InvocableStreamPipesEntity sepa, String staticPropertyName) {
        for (StaticProperty p : sepa.getStaticProperties()) {
            if (!p.getInternalName().equals(staticPropertyName) || !(p instanceof OneOfStaticProperty)) continue;
            OneOfStaticProperty thisProperty = (OneOfStaticProperty)p;
            for (Option option : thisProperty.getOptions()) {
                if (!option.isSelected()) continue;
                return option.getName();
            }
        }
        return null;
    }

    public static String getRemoteOneOfProperty(InvocableStreamPipesEntity sepa, String staticPropertyName) {
        for (StaticProperty p : sepa.getStaticProperties()) {
            if (!p.getInternalName().equals(staticPropertyName) || !(p instanceof RemoteOneOfStaticProperty)) continue;
            RemoteOneOfStaticProperty thisProperty = (RemoteOneOfStaticProperty)p;
            for (Option option : thisProperty.getOptions()) {
                if (!option.isSelected()) continue;
                return option.getName();
            }
        }
        return null;
    }

    public static String getFullPropertyName(EventProperty property, List<EventProperty> topLevelProperties, String initialPrefix, char delimiter) {
        for (EventProperty schemaProperty : topLevelProperties) {
            if (property.getElementId().equals(schemaProperty.getElementId())) {
                return initialPrefix + property.getRuntimeName();
            }
            if (!(schemaProperty instanceof EventPropertyNested)) continue;
            return SepaUtils.getFullPropertyName(property, ((EventPropertyNested)schemaProperty).getEventProperties(), initialPrefix + schemaProperty.getRuntimeName() + delimiter, delimiter);
        }
        return null;
    }

    public static EventProperty getEventPropertyById(DataProcessorInvocation graph, URI replaceFrom) {
        for (SpDataStream stream : graph.getInputStreams()) {
            for (EventProperty p : stream.getEventSchema().getEventProperties()) {
                if (!p.getElementId().equals(replaceFrom.toString())) continue;
                return p;
            }
        }
        return null;
    }
}

