/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.graph;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.base.ConsumableStreamPipesEntity;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/DataSinkDescription")
@Entity
public class DataSinkDescription
extends ConsumableStreamPipesEntity {
    private static final long serialVersionUID = -6553066396392585731L;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasEcType")
    private List<String> category;

    public DataSinkDescription(String uri, String name, String description, String iconUrl) {
        super(uri, name, description, iconUrl);
        this.spDataStreams = new ArrayList();
        this.category = new ArrayList<String>();
    }

    public DataSinkDescription(DataSinkDescription other) {
        super(other);
        this.category = new Cloner().ecTypes(other.getCategory());
    }

    public DataSinkDescription(String uri, String name, String description) {
        this(uri, name, description, "");
        this.category = new ArrayList<String>();
    }

    public DataSinkDescription() {
        this.category = new ArrayList<String>();
    }

    public List<String> getCategory() {
        return this.category;
    }

    public void setCategory(List<String> category) {
        this.category = category;
    }
}

