/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.graph;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="PipelineElementContainer")
@Entity
public class PipelineElementContainer
extends NamedStreamPipesEntity {
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="hasPipelineElements")
    private List<NamedStreamPipesEntity> pipelineElementDescriptions;

    public PipelineElementContainer(PipelineElementContainer other) {
        super(other);
        if (other.getPipelineElementDescriptions() != null) {
            this.pipelineElementDescriptions = new Cloner().cloneDescriptions(other.getPipelineElementDescriptions());
        }
    }

    public PipelineElementContainer(String containerId, String name, String description) {
        super(containerId, name, description);
        this.pipelineElementDescriptions = new ArrayList<NamedStreamPipesEntity>();
    }

    public List<NamedStreamPipesEntity> getPipelineElementDescriptions() {
        return this.pipelineElementDescriptions;
    }

    public void setPipelineElementDescriptions(List<NamedStreamPipesEntity> pipelineElementDescriptions) {
        this.pipelineElementDescriptions = pipelineElementDescriptions;
    }
}

