/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.grounding;

import javax.persistence.Entity;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.grounding.SimpleTopicDefinition;
import org.streampipes.model.grounding.TransportProtocol;
import org.streampipes.model.grounding.WildcardTopicDefinition;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/KafkaTransportProtocol")
@Entity
public class KafkaTransportProtocol
extends TransportProtocol {
    private static final long serialVersionUID = -4067982203807146257L;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/zookeeperHost")
    private String zookeeperHost;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/zookeeperPort")
    private int zookeeperPort;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/kafkaPort")
    private int kafkaPort;

    public KafkaTransportProtocol(String kafkaHost, int kafkaPort, String topic, String zookeeperHost, int zookeeperPort) {
        super(kafkaHost, new SimpleTopicDefinition(topic));
        this.zookeeperHost = zookeeperHost;
        this.zookeeperPort = zookeeperPort;
        this.kafkaPort = kafkaPort;
    }

    public KafkaTransportProtocol(KafkaTransportProtocol other) {
        super(other);
        this.kafkaPort = other.getKafkaPort();
        this.zookeeperHost = other.getZookeeperHost();
        this.zookeeperPort = other.getZookeeperPort();
    }

    public KafkaTransportProtocol(String kafkaHost, Integer kafkaPort, WildcardTopicDefinition wildcardTopicDefinition) {
        super(kafkaHost, wildcardTopicDefinition);
        this.kafkaPort = kafkaPort;
        this.zookeeperHost = kafkaHost;
        this.zookeeperPort = kafkaPort;
    }

    public KafkaTransportProtocol() {
    }

    public String getZookeeperHost() {
        return this.zookeeperHost;
    }

    public void setZookeeperHost(String zookeeperHost) {
        this.zookeeperHost = zookeeperHost;
    }

    public int getZookeeperPort() {
        return this.zookeeperPort;
    }

    public void setZookeeperPort(int zookeeperPort) {
        this.zookeeperPort = zookeeperPort;
    }

    public int getKafkaPort() {
        return this.kafkaPort;
    }

    public void setKafkaPort(int kafkaPort) {
        this.kafkaPort = kafkaPort;
    }
}

